self.onmessage=async function(e){const{type,payload}=e.data;if(type==="start"){const{text,level,iterations,hash_algorithm}=payload;const pattern=new RegExp("^0{"+level+"}");let count=0;const MAX_ITERATIONS=1e9;while(iterations>0&&count<MAX_ITERATIONS){let hashBuffer;try{switch(hash_algorithm){case"PBKDF2":hashBuffer=await pbkdf2Subtle(text+count,"JoomlaHashCashSalt",1e3,"SHA-256",32);break;case"PBKDF264KB":hashBuffer=await pbkdf264kbSubtle(text+count);break;case"256":case"384":case"512":hashBuffer=await shaSubtle(text+count,hash_algorithm);break;default:self.postMessage({type:"error",error:"Unsupported algorithm"});return}const hashString=Array.from(new Uint8Array(hashBuffer)).map(b=>b.toString(16).padStart(2,"0")).join("");if(pattern.test(hashString)){self.postMessage({type:"success",count:count});return}count++;if(count%1e5===0){self.postMessage({type:"progress",count:count})}}catch(err){count++}}self.postMessage({type:"failed",reason:"exhausted iterations"})}};async function shaSubtle(text,algo="256"){const encoder=new TextEncoder;const textBuffer=encoder.encode(text);const hashBuffer=await self.crypto.subtle.digest("SHA-"+algo,textBuffer);return hashBuffer}async function pbkdf2Subtle(text,salt,iterations,hash="SHA-256",keyLength=32){const encoder=new TextEncoder;const textBuffer=encoder.encode(text);const saltBuffer=encoder.encode(salt);const key=await self.crypto.subtle.importKey("raw",textBuffer,{name:"PBKDF2"},false,["deriveBits"]);const params={name:"PBKDF2",hash:hash,salt:saltBuffer,iterations:iterations};const derivedBits=await self.crypto.subtle.deriveBits(params,key,keyLength*8);return derivedBits}async function pbkdf264kbSubtle(text){const encoder=new TextEncoder;const mem=new Uint8Array(64*1024);const inputBuffer=encoder.encode(text);const saltHash=await self.crypto.subtle.digest("SHA-256",inputBuffer);const salt=new Uint8Array(saltHash).slice(0,16);for(let i=0;i<64;i++){self.crypto.getRandomValues(mem);await self.crypto.subtle.digest("SHA-256",mem)}const baseKey=await self.crypto.subtle.importKey("raw",inputBuffer,{name:"PBKDF2"},false,["deriveBits"]);const derived=await self.crypto.subtle.deriveBits({name:"PBKDF2",salt:salt.buffer,iterations:15e3,hash:"SHA-256"},baseKey,256);const hash=Array.from(new Uint8Array(derived)).map(b=>b.toString(16).padStart(2,"0")).join("");return derived}