<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Console.indexingapi
 *
 * @copyright   (C) 2022 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use RicheyWeb\Plugin\Console\IndexingAPI\Extension\IndexingAPI;

return new class implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.2.0
     */
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $dispatcher = $container->get(DispatcherInterface::class);
                $plugin     = new IndexingAPI(
                    $dispatcher,
                    (array) PluginHelper::getPlugin('console', 'indexingapi')
                );

                return $plugin;
            }
        );
    }
};