<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Console.indexingapi
 *
 * @copyright   (C) 2022 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\Console\IndexingAPI\Extension;

\defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Application\ApplicationEvents;
use Joomla\CMS\Factory;
use RicheyWeb\Plugin\Console\IndexingAPI\CliCommand\PublishedCliCommand;
use RicheyWeb\Plugin\Console\IndexingAPI\CliCommand\SubmitCliCommand;

class IndexingAPI extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            \Joomla\Application\ApplicationEvents::BEFORE_EXECUTE => 'registerCommands',
        ];
    }

    public function registerCommands(): void
    {
        $app = Factory::getApplication();
        $app->addCommand(new PublishedCliCommand());
        $app->addCommand(new SubmitCliCommand());
    }
}