<?php
/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\Content\AgeOf\Extension;

defined('_JEXEC') or die;

class TagParser {
    protected static $instances = [];
    private $identifier = '';
    private $options = [
        'bracket'=>'{}',
        'alternateclose'=>false,
        'selfclosing'=>false
    ];
    public $tags = [];
    public $total = 0;
    public function __construct($identifier=false,$options=false) {
        if($identifier) {
            $this->identifier = $identifier;
        } else {
            return false; // no identifier, no instance
        }
        if($options) {
            $this->setOptions($options);
        }
    }
    public static function getInstance($identifier=false,$options=false) {
        $instanceid = $identifier?:'';
        if(empty(self::$instances[$instanceid])) {
            self::$instances[$instanceid] = new TagParser($identifier,$options);
        }
        return self::$instances[$instanceid];
    }
    public function setIdentifier($identifier=false) {
        if($identifier) {
            $this->identifier = $identifier;
        }
        return $this;
    }
    public function setOptions($options=array()) {
        foreach((array)$options as $key=>$option) {
            $this->options[$key]=$option;
        }
        switch(strlen($this->options['bracket'])) {
            case 1:
                $this->options['bracket'] = $this->options['bracket'].$this->options['bracket'];
                break;
            case 2:
            default:
                $half = floor(strlen($this->options['bracket'])/2);
                $bracket = array(substr($this->options['bracket'],0,$half),substr($this->options['bracket'],$half*-1));
                $this->options['bracket'] = $bracket;
                break;
        }
        if(!is_array($this->options['bracket']) && strlen($this->options['bracket']) == 1) {
            $this->options['bracket'] = $this->options['bracket'].$this->options['bracket'];   
        }
        return $this;
    }
    public function parse($content) {
        $regex ='/'.$this->bracket('open').$this->identifier.'\s*?(?<params>.*?)'.$this->bracket('close');
        if(!$this->options['selfclosing']) {
            $regex.='(?<content>.*?)(?<closetag>'.$this->bracket('open').'\/'.($this->options['alternateclose']?$this->options['alternateclose']:$this->identifier).$this->bracket('close').')';
        }
        $regex.='/';
        $this->tags = []; // clear previously parsed tags
        $matches = [];
        preg_match_all($regex,$content,$matches);
        foreach($matches[0] as $key=>$match) {
            $this->total++;
            // if we use the tag as the key, we won't have duplicate tags
            $tagkey = md5($match); // using a cheap hash
            if(isset($this->tags[$tagkey])) {
                continue;
            }
            $this->tags[$tagkey] = new TagParserItem($match,$matches['params'][$key],$this->total);
            if(!$this->options['selfclosing']) $this->tags[$tagkey]->content = $matches['content'][$key];
        }
    }    
    public function resetTags() {
        $this->tags = array();
        return $this;
    }
    private function bracket($type='open') {
        return preg_quote(($type=='open')?$this->options['bracket'][0]:$this->options['bracket'][1]);
    }
}
class TagParserItem {
    public $tag;
    public $tagid=0;
    public $params = false;
    public $content = false;
    public function __construct($tag,$params,$tagid) {
        $this->tag = $tag;
        $this->tagid = $tagid;
        if(strlen($params)) {
            $paramsdom = new \DOMDocument;
            $paramsdom->loadHTML('<br '.trim($params).' />');
            $paramsxml = simplexml_import_dom($paramsdom->documentElement);
            if(count($paramsxml->body->br->attributes())) {
                $this->params = ((array)$paramsxml->body->br->attributes())['@attributes'];
            }
        }
    }
    public function getParam($name,$default) {
        if(isset($this->params[$name]) && empty($this->params[$name])) {
            return true;
        }
        return $this->params[$name]??$default;
    }
    public function getContent($default='') {
        return $this->content??$default;
    }
    public function replace($content,$replacement='') {
        return str_replace($this->tag,$replacement,$content);
    }
}