<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Language\Text;
?>
<div class="card">
  <a href="<?= $product->url;?>" target="_blank">
    <img src="<?= $product->image;?>" class="card-img-top" alt="<?= $product->title;?>">
  </a>
  <div class="card-body">
    <h5 class="card-title"><a target="_blank" href="<?= $product->url;?>"><?= $product->title;?></a></h5>
    <?php foreach($product->features as $feature) : ?>
    <p class="card-text"><?= $feature;?></p>
    <?php endforeach;?>
  </div>
  <div class="card-footer">
    <a target="_blank" href="<?= $product->url;?>" class="btn <?= $this->params->get('button','btn-dark');?> <?= $this->params->get('button_size','');?> float-end">
        <i class="fab fa-brands fa-amazon fa-fw me-2" style="color:#ff9800;"></i>
        <?php echo Text::_('PLG_CONTENT_APAAPI_BUTTON_TEXT');?>
    </a>
  </div>
</div>