<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Content\BeforeAfter\Extension;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

final class BeforeAfter extends CMSPlugin 
{

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepare' => 'onContentPrepare',
		];
	}

    public function onContentPrepare($context, &$article, &$params, $page = 0) {

        // Only execute if the article text is not empty
        if (empty($article->text)) {
            return;
        }

        if ($context == 'com_finder.indexer')
        {
                return true;
        }
        
        // only execute if the article text contains the plg_content_beforeafter class name tag
        if(!preg_match('/plg_content_beforeafter/',$article->text)) return;

        Factory::getDocument()->addStyleSheet(Uri::root(true).'/media/plg_content_beforeafter/css/image-comparison-slider.css', ['version' => 'auto']);
        Factory::getDocument()->addScript(Uri::root(true).'/media/plg_content_beforeafter/js/image-comparison-slider.js', ['version' => 'auto']);
    }
}
