<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Content\IndexingAPI\Extension;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

/*
POST /IndexNow HTTP/1.1
Content-Type: application/json; charset=utf-8
Host: api.indexnow.org
{
  "host": "www.example.org",
  "key": "9d8972fd3e764a048ff4a6ca9488bdd9",
  "keyLocation": "https://www.example.org/9d8972fd3e764a048ff4a6ca9488bdd9.txt",
  "urlList": [
      "https://www.example.org/url1",
      "https://www.example.org/folder/url2",
      "https://www.example.org/url3"
      ]
}
*/

class BingIndexingAPI
{
    public static function indexNow($key,$url,$rooturi)
    {
        self::keyFile($key);
        $app = Factory::getApplication();
        if($app->isClient('cli')) {
            $host = $rooturi;
            if($host === false) {
                $host = Uri::root();
            }
        } else {
            $host = Uri::root();
        }
        // if $host ends with a slash, remove it
        if(substr($host,-1) == '/') {
            $host = substr($host,0,-1);
        }
        $data = [
            'host' => $host,
            'key' => $key,
            'keyLocation' => $host.'/'.$key.'.txt',
            'urlList' => [$url]
        ];
        // initiate CURL post
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.indexnow.org/indexnow');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json; charset=utf-8']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        
        // return the HTTP response code
        $response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return $response;
    }
    private static function keyFile($key) {
        if(!file_exists(JPATH_ROOT.'/'.$key.'.txt')) {
            file_put_contents(JPATH_ROOT.'/'.$key.'.txt', $key);
        }
    }
}