<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Content\IndexingAPI\Extension;

defined('_JEXEC') or die;

require_once __DIR__.'/../vendor/autoload.php';

// require_once JPATH_PLUGINS . '/content/indexingapi/src/vendor/autoload.php';

class GoogleIndexingAPI
{
    public static function getGoogleClient($jsonkey)
    {
        $client = new \Google_Client();
        $client->setAuthConfig(json_decode($jsonkey, true));
        $client->addScope('https://www.googleapis.com/auth/indexing');
        return $client;
    }

    public static function getAccessToken($jsonkey,$endpoint,$content)
    {
        $client = self::getGoogleClient($jsonkey);
        $httpClient = $client->authorize();
        $response = $httpClient->post($endpoint, [ 'body' => $content ]);
        $status_code = $response->getStatusCode();
        return $status_code;
    }
}