class plg_content_miniglobe{markerInstancedMesh=null;markerCount=0;maxMarkers=1e4;dummy=new THREE.Object3D;worker=null;radius=64;depth=128;rootPath=Joomla.getOptions("system.paths").root;options={bumpmap:false,clouds:false,textureImage:"media/plg_content_miniglobe/images/default.webp",bumpmapImage:"media/plg_content_miniglobe/images/bumpmap.webp",cloudsImage:"media/plg_content_miniglobe/images/clouds.webp",brightness:1,speed:.005,hoverStop:false,markerColor:"#ff0000",markerSize:.03,markers:[],markersAJAX:false,markersKML:false,markersAJAXInterval:0};group=null;globe=null;clouds=null;markers=[];container=null;camera=null;scene=null;renderer=null;constructor(container,options=null){if(options){Object.assign(this.options,options)}this.container=container;this.init()}init=async()=>{this.scene=new THREE.Scene;this.camera=new THREE.PerspectiveCamera(75,this.container.clientWidth/this.container.clientHeight,.1,1e3);this.camera.position.z=this.radius*2.1;this.renderer=new THREE.WebGLRenderer({alpha:true,preserveDrawingBuffer:true});this.renderer.setSize(this.container.clientWidth,this.container.clientHeight);this.container.appendChild(this.renderer.domElement);window.addEventListener("resize",this.onWindowResize.bind(this));this.container.addEventListener("miniglobe:initialized",async event=>{this.container.classList.add("miniglobe-initialized")});this.container.addEventListener("miniglobe:ready",async event=>{const workerUrl=this.rootPath+"/media/plg_content_miniglobe/js/worker.js?"+Joomla.getOptions("plg_content_miniglobe").mediaVersion;this.worker=new Worker(workerUrl);this.worker.onmessage=e=>{if(e.data.success){this.removeMarkers();this.processMarkersArray(e.data.markers)}else{console.error("Worker error:",e.data.error)}};if(this.options.markers&&this.options.markers.length){this.options.markers.forEach(marker=>{this.addMarker(marker.lat,marker.lon,marker.size,marker.color)})}this.animate();this.onWindowResize();if(this.options.hoverStop){this.container.addEventListener("mouseover",()=>{this.stopAnimation()});this.container.addEventListener("mouseout",()=>{this.animate()})}this.container.dispatchEvent(new CustomEvent("miniglobe:initialized",{detail:{container:this.container}}))});this.renderGlobe()};renderGlobe=async()=>{this.group=new THREE.Group;const ambientLight=new THREE.AmbientLight(16777215,this.options.brightness);this.scene.add(ambientLight);const globeGeometry=new THREE.SphereGeometry(this.radius,this.depth,this.depth);const globeTexture=await this.loadTexture(this.options.textureImage);globeTexture.colorSpace=THREE.SRGBColorSpace;globeTexture.wrapS=THREE.RepeatWrapping;globeTexture.wrapT=THREE.ClampToEdgeWrapping;globeTexture.offset.set(0,0);globeTexture.repeat.set(1,1);let materialOptions={transparent:true,map:globeTexture};if(this.options.bumpmap){const bumpTexture=await this.loadTexture(this.options.bumpmapImage);materialOptions.bumpMap=bumpTexture;materialOptions.bumpScale=.3}const globeMaterial=new THREE.MeshStandardMaterial(materialOptions);this.globe=new THREE.Mesh(globeGeometry,globeMaterial);this.group.add(this.globe);if(this.options.clouds){const cloudGeometry=new THREE.SphereGeometry(this.radius*1.005,this.depth,this.depth);const cloudTexture=await this.loadTexture(this.options.cloudsImage);const cloudMaterial=new THREE.MeshStandardMaterial({alphaMap:cloudTexture,transparent:true});this.clouds=new THREE.Mesh(cloudGeometry,cloudMaterial);this.group.add(this.clouds)}this.scene.add(this.group);this.container.dispatchEvent(new CustomEvent("miniglobe:ready",{detail:{container:this.container}}))};loadTexture=async path=>{const url=path.startsWith("http")?path:this.rootPath+"/"+path;let textureLoader=new THREE.TextureLoader;return new Promise(resolve=>{textureLoader.load(url,texture=>{resolve(texture)})})};addKMLMarkers=()=>{if(!this.options.markersKML)return;let url=this.options.markersKML.startsWith("http")?this.options.markersKML:this.rootPath+"/"+this.options.markersKML;this.worker.postMessage({type:"kml",url:url})};addAJAXMarkers=()=>{if(!this.options.markersAJAX)return;let url=this.options.markersAJAX.startsWith("http")?this.options.markersAJAX:this.rootPath+"/"+this.options.markersAJAX;const loadMarkers=()=>{this.worker.postMessage({type:"ajax",url:url})};if(this.options.markersAJAXInterval&&parseInt(this.options.markersAJAXInterval)>0){setInterval(loadMarkers,parseInt(this.options.markersAJAXInterval)*1e3)}loadMarkers()};processMarkersArray(markers){if(!Array.isArray(markers)||markers.length===0)return;let index=0;const batchSize=20;const addBatch=()=>{const end=Math.min(index+batchSize,markers.length);for(;index<end;index++){const marker=markers[index];this.addMarker(marker.lat,marker.lon,marker.size??false,marker.color??false)}if(index<markers.length){requestAnimationFrame(addBatch)}};addBatch()}addMarker(lat,lon,size=false,color=false){size=size?size:parseFloat(this.options.markerSize);color=color?color:this.options.markerColor;console.log(color);if(!lat||!lon||!this.globe)return;if(!this.markerInstancedMesh){const geometry=new THREE.SphereGeometry(1,this.depth/4,this.depth/4);const vertexCount=geometry.attributes.position.count;const vertexColors=new Float32Array(vertexCount*3);vertexColors.fill(1);geometry.setAttribute("color",new THREE.BufferAttribute(vertexColors,3));const material=new THREE.MeshBasicMaterial({vertexColors:true});this.markerInstancedMesh=new THREE.InstancedMesh(geometry,material,this.maxMarkers);this.markerInstancedMesh.instanceMatrix.setUsage(THREE.DynamicDrawUsage);this.markerInstancedMesh.instanceColor=new THREE.InstancedBufferAttribute(new Float32Array(this.maxMarkers*3),3);this.markerInstancedMesh.instanceColor.setUsage(THREE.DynamicDrawUsage);this.globe.add(this.markerInstancedMesh)}const position=this.latLonToVector3(lat,lon,this.radius*1.01);this.dummy.position.copy(position);this.dummy.scale.setScalar(size*this.radius);this.dummy.updateMatrix();this.markerInstancedMesh.setMatrixAt(this.markerCount,this.dummy.matrix);const c=new THREE.Color(color);this.markerInstancedMesh.instanceColor.setXYZ(this.markerCount,c.r,c.g,c.b);this.markerInstancedMesh.instanceMatrix.needsUpdate=true;this.markerInstancedMesh.instanceColor.needsUpdate=true;this.markerCount++;this.markerInstancedMesh.count=this.markerCount}removeMarkers(){if(this.markerInstancedMesh){this.markerInstancedMesh.count=0;this.markerCount=0;this.markerInstancedMesh.instanceMatrix.needsUpdate=true;if(this.markerInstancedMesh.instanceColor){this.markerInstancedMesh.instanceColor.needsUpdate=true}}}onWindowResize(){this.camera.aspect=this.container.clientWidth/this.container.clientHeight;this.camera.updateProjectionMatrix();this.renderer.setSize(this.container.clientWidth,this.container.clientWidth)}animate(){this.animation=requestAnimationFrame(this.animate.bind(this));this.group.rotation.y+=parseFloat(this.options.speed);if(this.clouds){this.clouds.rotation.y-=parseFloat(this.options.speed)/10}this.renderer.render(this.scene,this.camera)}stopAnimation(){cancelAnimationFrame(this.animation)}latLonToVector3(lat,lon,radius){const phi=(90-lat)*Math.PI/180;const theta=(lon+180)*Math.PI/180;const x=-radius*Math.sin(phi)*Math.cos(theta);const z=radius*Math.sin(phi)*Math.sin(theta);const y=radius*Math.cos(phi);return new THREE.Vector3(x,y,z)}destroy(){this.worker.terminate();this.stopAnimation();window.removeEventListener("resize",this.onWindowResize.bind(this));this.renderer.dispose();this.container.innerHTML=""}}window.addEventListener("DOMContentLoaded",()=>{const globes=document.querySelectorAll(".plg_content_miniglobe");globes.forEach(globe=>{const options=JSON.parse(JSON.stringify(Joomla.getOptions("plg_content_miniglobe")));const optionNames=["bumpmap","clouds","hoverStop","textureImage","bumpmapImage","cloudsImage","brightness","speed","markerColor","markerSize","markers","markersAJAX","markersKML","markersAJAXInterval"];optionNames.forEach(optionName=>{if(!globe.dataset[optionName.toLowerCase()])return;let value=globe.dataset[optionName.toLowerCase()]??null;if(value===null)return;switch(optionName){case"bumpmap":case"clouds":case"hoverStop":value=parseInt(value)?true:false;break;case"brightness":case"speed":case"markerSize":value=parseFloat(value);break;case"markers":try{markers=JSON.parse(value);if(Array.isArray(markers)){value=[];markers.forEach(marker=>{let item={lat:marker[0],lon:marker[1],size:marker[2]??false,color:marker[3]??false};value.push(item)})}}catch(e){console.error("Invalid JSON for markers:",value);value=[]}break;case"markersAJAX":globe.addEventListener("miniglobe:initialized",async event=>{const container=event.detail.container;const globeInstance=container.MiniGlobe;if(!globeInstance)return;globeInstance.addAJAXMarkers()});break;case"markersKML":globe.addEventListener("miniglobe:initialized",async event=>{const container=event.detail.container;const globeInstance=container.MiniGlobe;if(!globeInstance)return;globeInstance.addKMLMarkers()});break}options[optionName]=value});globe.MiniGlobe=new plg_content_miniglobe(globe,options)})});class KMLTranslator{constructor(kmlData){this.kmlData=kmlData;this.translatedData={}}translate(){const parser=new DOMParser;const xmlDoc=parser.parseFromString(this.kmlData,"text/xml");this.translatedData.placemarks=[];const placemarks=xmlDoc.getElementsByTagName("Placemark");for(let placemark of placemarks){const name=placemark.getElementsByTagName("name")[0]?.textContent||"Unnamed";const coordinates=placemark.getElementsByTagName("coordinates")[0]?.textContent.trim()||"";const coordsArray=coordinates.split(",").map(coord=>parseFloat(coord));if(coordsArray.length>=2){this.translatedData.placemarks.push({lat:coordsArray[1],lon:coordsArray[0]})}}}}
