self.onmessage = async (e) => {
    const { type, url } = e.data;
    try {
        if (type === 'ajax') {
            const response = await fetch(url, { method: 'GET', cache: 'no-cache' });
            if (!response.ok) throw new Error(response.statusText);
            const markers = await response.json();
            self.postMessage({ success: true, markers });
        } else if (type === 'kml') {
            const response = await fetch(url, { method: 'GET', cache: 'no-cache' });
            if (!response.ok) throw new Error(response.statusText);
            const kmlText = await response.text();
            const markers = []; // KML parsing to be implemented
            const coordRegex = /<coordinates>\s*([^<]+)\s*<\/coordinates>/gi;
            let match;
            while ((match = coordRegex.exec(kmlText)) !== null) {
                const coordStr = match[1].trim();
                const coordsArray = coordStr.split(",").map(coord => parseFloat(coord.trim()));
                if (coordsArray.length >= 2) {
                    markers.push({ lat: coordsArray[1], lon: coordsArray[0] });
                }
            }
            self.postMessage({ success: true, markers });
        }
    } catch (error) {
        self.postMessage({ success: false, error: error.message });
    }
};