var plg_fields_location_class = function() {
    var root = this;
    this.options = {};
    this.maps = {};
    this.markers = {};
    this.resizeListener = false;
    var construct = async function() {
        var options = Joomla.getOptions('plg_fields_location');
        Object.getOwnPropertyNames(options).forEach(async function(id){
            root.options[id] = options[id];
            root.options[id].latLng = {lat: options[id].center[0],lng:options[id].center[1]};
            switch(typeof options[id].target) {
                // no target means no field, so it's a display only map.
                case 'undefined':
                    await root.setupMap(id);
                    root.setupMarker(id);
                    break;
                default:
                    await root.setupField(id);
                    await root.setupMap(id);
                    await root.setupMarker(id);
                    if(root.options[id].searchbox) {
                        await root.setupSearch(id);
                    }
                    await root.setupZoomEvent(id);
                    root.setupClickEvent(id);
                    break;
            }       
        });
        return;
    }
    this.setupField = async function(id) {
        var options = root.options[id];
        var element = document.getElementById(options.element);
        if(element !== null) {
            return;
        }
        var target = document.getElementById(options.target);
        var div = document.createElement('div');
        div.id = options.element;
        target.parentNode.insertBefore(div,target.nextSibling);
        return;
    }
    this.setupClickEvent = function(id) {
        root.maps[id].addListener('click',function(event){
            console.log(event);
            var o = {};
            o.latlng = {lat:event.latLng.lat(),lng:event.latLng.lng()};
            o.zoom = root.maps[id].getZoom();
            root.storeValue(id,o);
            root.markers[id].position = event.latLng;
        });
        return;
    }
    this.setupZoomEvent = function(id) {
        root.maps[id].addListener('zoom_changed',function(){
            let zoomLevel = root.maps[id].getZoom();
            let target = document.getElementById(root.options[id].target);
            let value = JSON.parse(target.value);
            value.zoom = zoomLevel;
            root.storeValue(id,value);
        });
    }
    this.storeValue = function(id,value){
        var options = root.options[id];
        var target = document.getElementById(options.target);
        target.value = JSON.stringify(value);
    }
    this.setupSearch = async function (id) {
        const {Place} = await google.maps.importLibrary("places");
        var options = root.options[id];
        var element = document.getElementById(options.element);
        var searchBox = document.createElement('div');
        searchBox.id = options.element + '_card';
        searchBox.className = 'place-autocomplete-card bg-dark mt-3 w-50';
        element.parentNode.insertBefore(searchBox,element);       
        const placeAutocomplete = new google.maps.places.PlaceAutocompleteElement();
        placeAutocomplete.id = "place-autocomplete-input-" + id;
        searchBox.appendChild(placeAutocomplete);
        root.maps[id].controls[google.maps.ControlPosition.TOP_LEFT].push(searchBox);
        infoWindow = new google.maps.InfoWindow();

        placeAutocomplete.addEventListener("gmp-placeselect", async ({ place }) => {
            await place.fetchFields({
                fields: ["displayName", "formattedAddress", "location"],
            });
            root.selectedPlace(id, place);
        });
        return;
    }
    this.selectedPlace = function(id, place) {
        var o = {};
        o.latlng = place.location;
        o.displayname = place.displayName??false;
        o.formattedAddress = place.formattedAddress??false;
        o.placeId = place.id??false;

        // If the place has a geometry, then present it on a map.
        if (place.viewport) {
            o.viewport = place.viewport;
            root.maps[id].fitBounds(place.viewport);
        } else {
            root.maps[id].setCenter(place.location);
            root.maps[id].setZoom(17);
        }
        o.zoom = root.maps[id].getZoom();
        root.storeValue(id,o);

        let content =
        '<div id="infowindow-content">' +
        '<span id="place-displayname" class="title">' +
        place.displayName +
        "</span><br />" +
        '<span id="place-address">' +
        place.formattedAddress +
        "</span>" +
        "</div>";

        root.updateInfoWindow(content, place.location);
        root.markers[id].position = place.location;        
    }
    this.updateInfoWindow = function(id, content, center) {
        infoWindow.setContent(content);
        infoWindow.setPosition(center);
        infoWindow.open({
            map:root.maps[id],
            anchor: root.markers[id],
            shouldFocus: false,
        });
        return;
    };
    this.setupMap = async function(id) {
        if(root.maps[id]??false) {
            return;
        }
        var options = root.options[id];
        // var center = { lat: options.center[0], lng: options.center[1] };
        var center = options.latLng;
        const { Map } = await google.maps.importLibrary("maps");
        var element = document.getElementById(options.element);
        root.maps[id] = new Map(element, {
            center: center,
            zoom: options.center[2]??options.zoom,
            mapId: 'plg_fields_location_map_'+options.id,
            streetViewControl: false,
            mapTypeId: options.mapTypeId.toLowerCase(),
            mapTypeControlOptions: {
                mapTypeIds: ['roadmap', 'satellite', 'hybrid', 'terrain'],
                style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
            }
        });
        if(!root.resizeListener) {
            root.setupResizeListener();
        }
        return;
    }
    this.setupMarker = async function(id) {
        var options = root.options[id];
        // var center = { lat: options.center[0], lng: options.center[1] };
        var center = options.latLng;
        const { AdvancedMarkerElement } = await google.maps.importLibrary("marker");
        root.markers[id] = new AdvancedMarkerElement({
            position: center,
            map: root.maps[id]
        });
        return;
    }
    this.setupResizeListener = function() {
        window.addEventListener('resize', function() {
            Object.getOwnPropertyNames(root.maps).forEach(function(id){
                console.log('Resizing map:',id);
                var mapcenter=root.maps[id].getCenter();
                google.maps.event.trigger(root.maps[id],"resize");
                root.maps[id].setCenter(mapcenter);
            });
        });
        root.resizeListener = true;
        return;
    }
    construct();
};
window.addEventListener('DOMContentLoaded',function(){
    plg_fields_location = new plg_fields_location_class();
});