<?php

/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

 
namespace Joomla\Plugin\Fields\Location\Extension;

use Joomla\CMS\Access\Access;
use Joomla\CMS\Form\Form;
use Joomla\Plugin\Fields\Location\Extension\LocationHelper;
use Joomla\Component\Fields\Administrator\Plugin\FieldsPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Fields Location Plugin
 *
 * @since  3.7.0
 */
class Location extends FieldsPlugin
{
	public $apikey = false;
    public $scriptAdded = false;
        
	/**
	 * Transforms the field into a DOM XML element and appends it as a child on the given parent.
	 *
	 * @param   stdClass    $field   The field.
	 * @param   DOMElement  $parent  The field node parent.
	 * @param   Form       $form    The form.
	 *
	 * @return  DOMElement
	 *
	 * @since   3.7.0
	 */
    public function onCustomFieldsPrepareDom($field, \DOMElement $parent, Form $form)
	{
		$fieldNode = parent::onCustomFieldsPrepareDom($field, $parent, $form);

		if (!$fieldNode)
		{
			return $fieldNode;
		}
        $this->apikey = $this->params->get('apikey', false);
        $app = Factory::getApplication();
		if ($this->apikey && $app->input->getCmd('layout', false) === 'edit')
		{
			$fieldNode->setAttribute('type', 'hidden');
            $debug = Factory::getConfig()->get('debug',false);
            $doc = Factory::getDocument();
			$fieldValue = json_decode($field->value)??false;
			if(!$fieldValue) {
				$fieldValue = new \stdClass();
				$fieldValue->latlng = [0,0];
				$fieldValue->zoom = $field->fieldparams->get('editzoom',1,'INTEGER');
			}
			$latlon = array_values((array)$fieldValue->latlng);
			$zoom = (int)$fieldValue->zoom??$field->fieldparams->get('editzoom',1,'INTEGER');
			// $latlon = (false===strpos($field->value,','))?array(0,0):explode(',', $field->value);
			$fieldid = 'plg_fields_location_' . $field->name . '_' . $field->id;
			$targetid = 'jform_com_fields_' . str_replace('-','_',$field->name);
            $urlvars = array();
            if($this->params->get('searchbox',false)) {
                $urlvars[] = 'libraries=places';
                Text::script('PLG_FIELDS_LOCATION_SEARCHBOX_PLACEHOLDER');
            }
			$width = $field->fieldparams->get('editwidth', '400px');
			$height = $field->fieldparams->get('editheight', '300px');
			$styleParams = array(
				'fieldid' => $fieldid,
				'width' => $width,
				'height' => $height
			);
            LocationHelper::loadMapsAPI($this->params, $styleParams, $debug);
			// $zoom = (int)$field->fieldparams->get('editzoom', 1);
			$options = array(
                'id'=>$field->id,
                'element'=>$fieldid,
                'target'=>$targetid,
				// 'zoom'=>(int)$field->fieldparams->get('editzoom', 1),
				'zoom'=>$zoom,
				'center'=>array((float)$latlon[0]??0, (float)$latlon[1]??0, (int)$fieldValue->zoom??$zoom),
				'mapTypeId'=>$field->fieldparams->get('mapstyle', 'ROADMAP'),
                'searchbox'=>($this->params->get('searchbox',0) && $field->fieldparams->get('searchbox',0))?1:0
			);
            $scriptoptions = $doc->getScriptOptions('plg_fields_location',[]);
            if(!isset($scriptoptions[$field->id])) {
                $scriptoptions[$field->id] = $options;
                $doc->addScriptOptions('plg_fields_location',$scriptoptions);
            }
		}
		
		return $fieldNode;
	}

}
