<?php

/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Fields\Location\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

abstract class LocationHelper {
    static $googlemaps = false;
    static $loaded = false;
    static $registered = array();
    static function register($id) {
        self::$registered[] = $id;
    }
    static function loadMapsAPI($params, $styleParams, $debug) {
        $debug = true;
        $doc = Factory::getApplication()->getDocument();
        $vars = array('key'=>$params->get('apikey', false),'v'=>'beta');
        if(static::$googlemaps === false) {
            $doc->addScriptDeclaration('(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})('.json_encode($vars).')');
            $doc->addScript(Uri::root(true) . '/media/plg_fields_location/js/plg_fields_location' . ($debug ? '' : '.min') . '.js', array('version' => 'auto'));
            static::$googlemaps = true;
        }
        $doc->addStyleDeclaration('#' . $styleParams['fieldid'] . ' { width: ' . ($styleParams['width'] == 'auto' ? '100%' : $styleParams['width']) . '; height: ' . ($styleParams['height'] == 'auto' ? '100%' : $styleParams['height']) . '; margin-bottom: 20px; }');
        static::$loaded = true;
    }

    static function createStaticMapURL($pluginparams, $latlonzoom, $zoom, $width, $height) {
        $apikey = $pluginparams->get('staticapikey', false);
        if(!$apikey) {
            return false;
        }
        $fieldValue = json_decode($latlonzoom);
        $latlon = $fieldValue->latlng->lat . ',' . $fieldValue->latlng->lng;
        $zoom = $fieldValue->zoom ?? $zoom;
        if($width == 'auto' || $height == 'auto') {
            $width = '400';
            $height = '300';
        }
        $size = array(str_replace('px','', $width), str_replace('px','', $height));
        $url = 'https://maps.googleapis.com/maps/api/staticmap?';
        $params = array();
        $params[] = 'center=' . $latlon;
        $params[] = 'zoom=' . $zoom;
        $params[] = 'size=' . implode("x", $size);
        $params[] = 'key=' . $apikey??'NoAPIKeyProvided';
        $params[] = 'markers=' . $latlon;
        $staticmapsurl = $url . implode("&", $params);
        if($pluginparams->get('cachestatic',false)) {
            $cachekey = md5($staticmapsurl);
            $imagepath = JPATH_ROOT . '/media/plg_fields_location/staticmaps/' . $cachekey . '.png';
            if(!file_exists($imagepath)) {
                $ch = curl_init($staticmapsurl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $image = curl_exec($ch);
                curl_close($ch);
                file_put_contents($imagepath, $image);
            }
            $staticmapsurl = Uri::root(true) . '/media/plg_fields_location/staticmaps/' . $cachekey . '.png';
        }
        return $staticmapsurl;
    }

    static function createMapsLink($latlonzoom) {
        $fieldValue = json_decode($latlonzoom);
        $anchor = 'https://www.google.com/maps/';
        $query = '?q='.$fieldValue->latlng->lat.','.$fieldValue->latlng->lng;

        // better than latlng
        $formattedAddress = $fieldValue->formattedAddress??false;
        if($formattedAddress) {
            $query = '?q='.urlencode($fieldValue->formattedAddress);
        }

        // better than formattedAddress
        $placeId = $fieldValue->placeId??false;
        if($placeId) {
            $query = 'place/?q=place_id:'.$fieldValue->placeId;
        }

        return $anchor.$query;
    }

}