<?php

/**
 * @copyright   Copyright (C) 2005 - 2017 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Plugin\Fields\Location\Extension\LocationHelper;

defined('_JEXEC') or die;

$app = Factory::getApplication();
$value = strlen(trim($field->value)) ? trim($field->value) : $field->fieldparams->get('default_value', false);

if ($value === false ) {
    return;
}

if (is_array($value)) {
    $value = implode(', ', $value);
}
$latlon = explode(',', $value);
$displaytype = $this->params->get('staticapikey', false) ? $field->fieldparams->get('displaytype', 'map') : 'map';
if ($app->input->getCmd('layout', false) !== 'edit') {
    if (!$this->params->get('apikey', false) || $displaytype == 'text') {
        echo Text::_('PLG_FIELDS_LOCATION_DISPLAY_LATITUDE') . $latlon[0];
        echo '<br />';
        echo Text::_('PLG_FIELDS_LOCATION_DISPLAY_LONGITUDE') . $latlon[1];
    } else {
        $zoom = $field->fieldparams->get('displayzoom', 1);
        $width = $field->fieldparams->get('displaywidth', 'auto');
        $height = $field->fieldparams->get('displayheight', '200px');
        $fieldid = 'plg_fields_location_' . $field->name . '_' . $field->id;
        $fieldValue = json_decode($field->value);
        $latlon = array_values((array)$fieldValue->latlng);
        $zoom = (int)$fieldValue->zoom??$field->fieldparams->get('displayzoom',1,'INTEGER');
        switch ($displaytype) {
            case 'map':
                $maptype = $field->fieldparams->get('maptype', 'ROADMAP');
                $fieldid = 'plg_fields_location_' . $field->name . '_' . $field->id;
                $styleParams = array(
                    'fieldid' => $fieldid,
                    'width' => $width,
                    'height' => $height
                );
                $debug = Factory::getConfig()->get('debug', false);

                $doc = Factory::getDocument();
                LocationHelper::loadMapsAPI($this->params, $styleParams, $debug);
                // $zoom = (int)$field->fieldparams->get('displayzoom', 1);
                $options = array(
                    'id' => $field->id,
                    'element' => $fieldid,
                    'zoom' => $zoom,
                    'center' => array((float)$latlon[0] ?: 0, (float)$latlon[1] ?: 0, (int)$latlon[2] ?: $zoom),
                    'mapTypeId' => $field->fieldparams->get('mapstyle', 'ROADMAP'),
                    'searchbox' => false,
                );
                $scriptoptions = $doc->getScriptOptions('plg_fields_location',[]);
                $scriptoptions[$field->id] = $options;
                $doc->addScriptOptions('plg_fields_location', $scriptoptions);
                echo '<div id="' . $fieldid . '"></div>';
                break;
            case 'static':
                $mapurl = LocationHelper::createStaticMapURL($this->params, $value, $zoom, $width, $height);
                $img = '<img src="' . $mapurl . '" alt="location" width="' . $width . '" height="' . $height . '">';
                if($field->fieldparams->get('linkstatic',0)) {
                    $link = LocationHelper::createMapsLink($field->value);
                    echo '<a href="'.$link . '" target="_blank">' . $img . '</a>';
                } else {
                    echo $img;
                }
                break;
            case 'link':
                $anchorText = $fieldValue->latlng->lat.', '.$fieldValue->latlng->lng;
                $formattedAddress = $fieldValue->formattedAddress??false;
                $displayname = $fieldValue->displayname??false;
                if($displayname || $formattedAddress) {                    
                    $anchorText = $displayname??'';
                    if($displayName !== false && $formattedAddress !== false) {
                        $anchorText .= ' - ';
                    }   
                    $anchorText .= $formattedAddress??'';  
                }
                $anchor = LocationHelper::createMapsLink($field->value);
                echo '<a href="'.$anchor . '" target="_blank">' . $anchorText . '</a>';
                break;
        }
    }
}