<?php

/**
 * @package     Joomla.Module
 * @subpackage  Module.mod_coolclock
 *
 * @copyright   (C) 2018 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Module\CoolClock\Site\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Modernclock Field class for the mod_coolclock Module.
 *
 * @since  3.9.1
 */
class ModernclockField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  3.9.1
     */
    protected $type = 'Modernclock';
    protected $hiddenDescription = true;

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   4.0.0
     */
    protected function getInput()
    {
        return '        <div id="'.$this->element['name'].'" class="mx-auto mod-coolclock coolclock ratio ratio-1x1" style="width:128px;height:128px;">
            <canvas id="'.$this->element['name'].'_canvas" class="rounded-circle ratio ratio-1x1 w-auto h-auto"></canvas>
        </div>';    
    }
}
