class CoolClockAdmin {
    basicCanvas = null;
    basicConfig = {};
    customConfig = {};
    constructor() {
        this.init();
    }

    init() {
        this.getBasicConfig(true);
        // this.basicCanvas = document.getElementById('basic_canvas');    
        // this.customCanvas = document.getElementById('custom_canvas');  
        // this.logoCanvas = document.getElementById('logo_canvas');  
        const customConfig = structuredClone(this.basicConfig);
        const customSkin = this.buildCustomSkin();
        
        if(this.basicConfig.skin === 'customSkin') {
            this.basicConfig.customSkin = customSkin;
        }
        new ModernClock('basic_canvas', this.basicConfig);

        const logoConfig = structuredClone(this.basicConfig);

        customConfig.skin = 'customSkin';
        customConfig.customSkin = customSkin;
        customConfig.showSecondHand = true;
        customConfig.showAMPM = true;
        new ModernClock('custom_canvas', customConfig);

        // set up event listener for customSkin input to update the clock when it changes
        const customSkinInput = document.querySelector('[name="jform[params][customSkin]"]');
        if(customSkinInput) {
            console.log('customSkin input change event setup');
            customSkinInput.addEventListener('change', (e) => {
                this.updateClock('custom_canvas','customSkin',JSON.parse(e.target.value));
            });
        }

        logoConfig.showSecondHand = true;
        logoConfig.showAMPM = true;
        new ModernClock('logos_canvas', logoConfig);

        const logoField = document.querySelector('[name="jform[params][logo]"]');
        if(logoField.value.length) {
            const logoObject = JSON.parse(logoField.value);
            console.log(logoObject);
            ['basic_canvas','custom_canvas','logos_canvas'].forEach(canvasId => {
                this.updateClock(canvasId,'logo',logoObject);
            });
        }
    }

    getBasicConfig(init=false) {
        const fields = {'skin':null,'showSecondHand':'bool','showAMPM':'bool','smoothSecondHand':'bool'};
        Object.keys(fields).forEach((key) => {
            const input = document.querySelectorAll(`[name="jform[params][${key}]"]`);
            this.basicConfig[key] = this.getInputValue(input, fields[key]);
        });
        this.basicConfig.gmtOffset = 0.0;
        this.basicConfig.useNTP = false;
    }

    getCustomConfig() {
        ['custom','csFaceBackgroundCB','csFaceBackgroundColor','csFaceBackgroundOpacity','csFaceBorderCB','csFaceBorderColor','csFaceBorderWidth','csFaceBorderRadius','csFaceBorderOpacity','csFaceMarkersCB','csFaceMarkersColor','csFaceMarkersSmall','csFaceMarkersLarge','csFaceMarkersStart'].forEach((key) => {
            this.customConfig[key] = document.querySelector(`[name="jform[params][${key}]"]`)?.value;
        });
        return this.customConfig;
    }

    updateClock(canvasId,key,value) {
        if(!Array.isArray(canvasId)) {
            canvasId = [canvasId];
        }        
        canvasId.forEach(id => {
            const instance = ModernClock.instances.get(id);
            if (instance) {
                if(key === 'logo'){
                    instance.updateOptions({logo: value});
                } else {
                    instance.updateOption(key,value);
                    if(key === 'skin' && value === 'customSkin') {
                        instance.updateOption('customSkin', this.buildCustomSkin());
                    }
                }
            }
        });
    }

    getInputValue(el,type) {
        switch(type) {
            case 'bool':
                // it's a radio - so we need to figure out which one is checked
                const input = el[0].parentNode.querySelector(`input:checked`);
                return parseInt(input?.value)?true:false;
            case 'float':
                return parseFloat(el[0]?.value) || 0;
            default:
                return el[0]?.value;
        }
    }

    buildCustomSkin(replace=false){
        const customSkinInput = document.querySelector('[name="jform[params][customSkin]"]');
        if(customSkinInput && customSkinInput.value && !replace) {
            return JSON.parse(customSkinInput.value);
        }
        const customSkin = {};
        const csFaceBackgroundCB = document.querySelector('[name="jform[params][csFaceBackgroundCB]"]');
        if(csFaceBackgroundCB.checked) {
            customSkin.face = {
                radius: 100,
                fillColor: document.querySelector('[name="jform[params][csFaceBackgroundColor]"]')?.value,
                alpha: parseFloat(document.querySelector('[name="jform[params][csFaceBackgroundOpacity]"]')?.value) || 0
            };
        }
        const csFaceBorderCB = document.querySelector('[name="jform[params][csFaceBorderCB]"]');
        if(csFaceBorderCB.checked) {
            customSkin.outerBorder = {
                lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceBorderWidth]"]')?.value) || 0,
                radius: parseFloat(document.querySelector('[name="jform[params][csFaceBorderRadius]"]')?.value) || 0,
                color: document.querySelector('[name="jform[params][csFaceBorderColor]"]')?.value,
                alpha: parseFloat(document.querySelector('[name="jform[params][csFaceBorderOpacity]"]')?.value) || 0
            };
        }
        const csFaceMarkersCB = document.querySelector('[name="jform[params][csFaceMarkersCB]"]');
        if(csFaceMarkersCB.checked) {
            customSkin.smallIndicator = {
                lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceMarkersSmall]"]')?.value) || 0,
                startAt: parseFloat(document.querySelector('[name="jform[params][csFaceMarkersStart]"]')?.value) || 0,
                endAt: parseFloat(document.querySelector('[name="jform[params][csFaceMarkersEnd]"]')?.value) || 0,
                color: document.querySelector('[name="jform[params][csFaceMarkersColor]"]')?.value || '#000000',
                alpha: 1
            }
            customSkin.largeIndicator = {
                lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceMarkersLarge]"]')?.value) || 0,
                startAt: (parseFloat(document.querySelector('[name="jform[params][csFaceMarkersStart]"]')?.value)-5) || 0,
                endAt: parseFloat(document.querySelector('[name="jform[params][csFaceMarkersEnd]"]')?.value) || 0,
                color: document.querySelector('[name="jform[params][csFaceMarkersColor]"]')?.value || '#000000',
                alpha: 1
            }
        }
        customSkin.hourHand = {
            lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceHourHandWidth]"]')?.value) || 0,
            startAt: (parseFloat(document.querySelector('[name="jform[params][csFaceHourHandTail]"]')?.value) || 0)*-1,
            endAt: parseFloat(document.querySelector('[name="jform[params][csFaceHourHandLength]"]')?.value) || 0,
            color: document.querySelector('[name="jform[params][csFaceHourHandColor]"]')?.value || '#000000',
            alpha: 1,
            lineCap: 'round'
        }
        customSkin.minuteHand = {
            lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceMinuteHandWidth]"]')?.value) || 0,
            startAt: (parseFloat(document.querySelector('[name="jform[params][csFaceMinuteHandTail]"]')?.value) || 0)*-1,
            endAt: parseFloat(document.querySelector('[name="jform[params][csFaceMinuteHandLength]"]')?.value) || 0,
            color: document.querySelector('[name="jform[params][csFaceMinuteHandColor]"]')?.value || '#000000',
            alpha: 1,
            lineCap: 'round'
        }
        customSkin.secondHand = {
            lineWidth: parseFloat(document.querySelector('[name="jform[params][csFaceSecondHandWidth]"]')?.value) || 0,
            startAt: (parseFloat(document.querySelector('[name="jform[params][csFaceSecondHandTail]"]')?.value) || 0)*-1,
            endAt: parseFloat(document.querySelector('[name="jform[params][csFaceSecondHandLength]"]')?.value) || 0,
            color: document.querySelector('[name="jform[params][csFaceSecondHandColor]"]')?.value || '#000000',
            alpha: 1,
            lineCap: 'round'
        }
        const csFaceCenterDotCB = document.querySelector('[name="jform[params][csFaceCenterDotCB]"]');
        if(csFaceCenterDotCB.checked) {
            customSkin.centerDot = {
                radius: parseFloat(document.querySelector('[name="jform[params][csFaceCenterDotRadius]"]')?.value) || 0,
                fillColor: document.querySelector('[name="jform[params][csFaceCenterDotColor]"]')?.value || '#000000',
                alpha: 1
            }
        }
        
        customSkinInput.value = JSON.stringify(customSkin,null,2);
        if(replace){
            window.coolClockAdmin.updateClock('custom_canvas','customSkin',JSON.parse(customSkinInput.value));
            if(this.basicConfig.skin === 'customSkin') {
                window.coolClockAdmin.updateClock('basic_canvas','customSkin',JSON.parse(customSkinInput.value));
            }
        }
        return customSkin;
    }

    updateLogo() {
        const logoObject = {alpha:1};
        const logoInput = document.querySelector('[name="jform[params][logo]"]');
        const logoType = document.querySelector('[name="jform[params][logoType]"]');
        let position = [];
        console.log(logoType.value)
        switch(logoType.value) {
            case '':
                logoInput.value = '';
                return;
            case 'text':
                logoObject.text = document.querySelector('[name="jform[params][logoText]"]')?.value || '';
                logoObject.fontSize = parseFloat(document.querySelector('[name="jform[params][logoTextFontSize]"]')?.value) || 0;
                logoObject.color = document.querySelector('[name="jform[params][logoTextColor]"]')?.value || '#000000';
                logoObject.fontWeight = document.querySelector('[name="jform[params][logoTextFontWeight]"]')?.value || 'normal';
                logoObject.fontFamily = document.querySelector('[name="jform[params][logoTextFontFamily]"]')?.value || 'Arial';
                position = (document.querySelector('[name="jform[params][logoPosition]"]')?.value || '0,-50').split(',');
                logoObject.position = {
                    x: parseInt(position[0]),
                    y: parseInt(position[1])
                };
                break;
            case 'url':
                logoObject.src = document.querySelector('[name="jform[params][logoImageSrc]"]')?.value || '';
                logoObject.width = parseInt(document.querySelector('[name="jform[params][logoWidth]"]')?.value) || 0;
                logoObject.height = parseInt(document.querySelector('[name="jform[params][logoHeight]"]')?.value) || 0;
                position = (document.querySelector('[name="jform[params][logoPosition]"]')?.value || '0,-50').split(',');
                logoObject.position = {
                    x: parseInt(position[0]),
                    y: parseInt(position[1])
                };
                break;
            case 'svg':
                logoObject.svg = document.querySelector('[name="jform[params][logoImageSVG]"]')?.value || '';
                logoObject.width = parseInt(document.querySelector('[name="jform[params][logoWidth]"]')?.value) || 0;
                logoObject.height = parseInt(document.querySelector('[name="jform[params][logoHeight]"]')?.value) || 0;
                position = (document.querySelector('[name="jform[params][logoPosition]"]')?.value || '0,-50').split(',');
                logoObject.position = {
                    x: parseInt(position[0]),
                    y: parseInt(position[1])
                };
                break;
        }
        logoInput.value = JSON.stringify(logoObject);
        if(logoObject.position??null) {
            ['basic_canvas','custom_canvas','logos_canvas'].forEach(canvasId => {
                window.coolClockAdmin.updateClock(canvasId,'logo',logoObject);
            });
        }
    }
}

document.addEventListener('DOMContentLoaded', () => {
    window.coolClockAdmin = new CoolClockAdmin();
    console.log('CoolClockAdmin initialized');
});