<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_coolclock
 *
 * @copyright   (C) 2009 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getApplication()->getDocument();
$wa = $doc->getWebAssetManager();
$modId = 'mod-coolclock' . $module->id;

$wa->registerAndUseScript('mod_coolclock', 'media/mod_coolclock/js/modernclock.js', ['defer' => true,'async' => true],['version'=>true]);

// we transform this array into JSON for the JavaScript side
$clockOptions = $doc->getScriptOptions('mod_coolclock',[]);
/* class options
      displayRadius: options.displayRadius || ModernClock.config.defaultRadius,
      skin: options.skin || ModernClock.config.defaultSkin,
      showSecondHand: options.showSecondHand !== false,
      showAMPM: options.showAMPM || false,
      gmtOffset: options.gmtOffset !== undefined ? parseFloat(options.gmtOffset) : 0,
      smoothSecondHand: options.smoothSecondHand !== false,
      onTick: options.onTick || null,
      customSkin: options.customSkin || null,
      responsive: options.responsive !== false,
      useNTP: options.useNTP || false,
      logo: options.logo || null
*/
$clock = [
    'responsive' => true,
    // 'displayRadius' => $params->get('displayRadius', null), // we use the default responsive behavior, allowing the container to determine the clock size
    'skin' => $params->get('skin', null),
    'showSecondHand' => (bool)$params->get('showSecondHand', true),
    'showAMPM' => (bool)$params->get('showAMPM', false),
    // 'gmtOffset' => (float)$params->get('gmtOffset', 0),
    'smoothSecondHand' => (bool)$params->get('smoothSecondHand', true),
    // 'onTick' => $params->get('onTick', null), // not used in Joomla implementation
    // 'customSkin' => $params->get('customSkin', null), // handled elsewhere
    // 'responsive' => (bool)$params->get('responsive', true), // not used in Joomla implementation - responsive is default
    'useNTP' => (bool)$params->get('useNTP', false),
    // 'useDateHeader' => $params->get('useDateHeader', null), // URL to fetch Date header from
    'logo' => $params->get('logo', null)
];
// remove null values
$clock = array_filter($clock, function($value) {
    return $value !== null;
});
if($clock['skin'] === 'customSkin') {
    $clock['customSkin'] = json_decode($params->get('customSkin', null),true);
}
if(($timezoneName = $params->get('gmtOffset', '')) !== '') {
    // Convert timezone name to GMT offset in hours
    $timezone = new DateTimeZone($timezoneName);
    $dateTime = new DateTime('now', $timezone);
    $offsetInSeconds = $timezone->getOffset($dateTime);
    $clock['gmtOffset'] = $offsetInSeconds / 3600;
}
if($clock['useNTP']) {
    unset($clock['useNTP']);
    $clock['useDateHeader'] = Uri::root(true) . '/index.php?option=com_ajax&format=raw';
}
if(strlen($clock['logo'])) {
    $clock['logo'] = json_decode($params->get('logo', null),true);
}
$clockOptions[$modId] = $clock;
$doc->addScriptOptions('mod_coolclock', $clockOptions);
?>

<div id="<?php echo $modId; ?>" class="mod-coolclock coolclock ratio ratio-1x1 w-100 text-center">
    <canvas id="<?php echo $modId; ?>_canvas" class="rounded-circle ratio ratio-1x1 w-auto h-auto"></canvas>
</div>
