self.onmessage = async (e) => {
    const baseUrl = e.data.url;
    const cacheBustUrl = `${baseUrl}?t=${Date.now()}`;
    // console.log('Worker fetching URL:', cacheBustUrl);

    // === PerformanceObserver setup (early, buffered) ===
    let observerResolved = false;
    let details = { dnsTime: 0, transferTime: 0, totalDuration: 0 };

    const timingPromise = new Promise(resolve => {
        const observer = new PerformanceObserver((list) => {
            for (const entry of list.getEntries()) {
                // Match our cache-busted URL (name includes the timestamp)
                if (entry.name.startsWith(baseUrl) || entry.name === cacheBustUrl) {
                    details.dnsTime = entry.domainLookupEnd - entry.domainLookupStart;
                    details.transferTime = entry.responseEnd - entry.responseStart;
                    details.totalDuration = entry.duration;
                    details.transferSize = entry.transferSize;
                    details.decodedBodySize = entry.decodedBodySize;

                    // console.log('PerformanceObserver entry captured:', {
                    //     totalDuration: entry.duration,
                    //     dnsTime: details.dnsTime,
                    //     transferTime: details.transferTime,
                    //     transferSize: entry.transferSize,
                    //     decodedBodySize: entry.decodedBodySize
                    // });

                    observer.disconnect(); // One-shot – we only care about our bait
                    observerResolved = true;
                    resolve();
                    return;
                }
            }
        });

        observer.observe({ type: 'resource', buffered: true });

        // Fallback in case observer never fires (e.g. hard block, no entry)
        setTimeout(() => {
            if (!observerResolved) {
                observer.disconnect();
                resolve();
            }
        }, 5000);
    });

    // === Perform the fetch ===
    let fetchSuccess = false;
    try {
        fetchSuccess = await self.fetchUrl(cacheBustUrl);
    } catch (_) {
        fetchSuccess = false;
    }

    // Wait for observer to finish (or timeout)
    await timingPromise;

    // After observer resolves and details populated
    let blocked = !fetchSuccess; // Default for rejects/no entry

    if (fetchSuccess && details.totalDuration > 0) {
    const tripleZero = 
        details.dnsTime === 0 &&
        details.transferSize < 1000 &&     // stubs always 0
        details.decodedBodySize < 1000;    // stubs always 0

    if (tripleZero) {
        blocked = true;   // Definitive stub
    } else {
        blocked = false;  // Has real payload or DNS → clean
    }
    } else {
    blocked = true;     // No entry = blocked
    }

    // console.log('Performance details:', details);

    self.postMessage({ blocked, details, url: cacheBustUrl });
};

self.fetchUrl = async (url) => {
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 2500); // 2.5s timeout

    try {
        const response = await fetch(url, {
            method: 'GET',
            // mode: 'no-cors',  // keep commented or remove – cors works now thanks to ACAO:*
            cache: 'no-store',
            redirect: 'follow',
            signal: controller.signal
        });
        clearTimeout(timeoutId);
        // console.log('Fetch response:', response);
        return true; // Fetch succeeded (could be real or stub)
    } catch (err) {
        // switch (err.name) {
        //     case 'TypeError': // uBlock
        //     case 'NetworkError':
        //     case 'AbortError':
        //         console.log('Fetch ' + err.name + ' (likely blocked):', err);
        //         break;
        //     default:
        //         console.log('Fetch error:', err.name);
        //         break;
        // }
        clearTimeout(timeoutId);
        return false;
    }
};