<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.articlehits
 *
 * @copyright   (C) 2020 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\ArticleHits\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Form\Form;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * System plugin to package multiple frontend scripts into single files to reduce requests.
 *
 * @since  5.0.0
 */
final class ArticleHits extends CMSPlugin
{
    protected $app;

    /**
     * Returns an array of events this subscriber will listen to.
     *
     * @return  array
     *
     * @since   4.0.0
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepareForm' => 'onContentPrepareForm'
        ];
    }
    
    public function onContentPrepareForm(Form $form) {
        if (!($form instanceof Form))
        {
            $this->_subject->setError('JERROR_NOT_A_FORM');

            return false;
        }

        // Check we are manipulating a valid form.
        $name = $form->getName();
        $custom = false;
        $fieldname = 'hits';
        $contexts = $this->getAHContexts();
        if(in_array($name, array_keys($contexts))) {
            $custom = true;
            $fieldname = $contexts[$name];
        }
        if (!$custom && $name != 'com_content.article')
        {
            return true;
        }
        $form->setFieldAttribute($fieldname,'readonly','false');
        $form->setFieldAttribute($fieldname,'filter','raw');
    }

    private function getAHContexts() {
        $contexts = [];
        $param = $this->params->get('contexts', [], 'array');
        foreach((array)$param as $c) {
            $contexts[$c->context] = $c->context_field;
        }
        return $contexts;
    }
}
