<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.donottrack
 *
 * @copyright   (C) 2023 Michael Richey. <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\System\DoNotTrack\Extension\DoNotTrack;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.4.0
     */
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin     = new DoNotTrack(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('system', 'donottrack')
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};