<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\LinkCanonical\Fixes;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonicalFix {
    public static function extraVars($vars,$valid,$leading='&') {
        // Cast known integers as integers, and urlencode everything else
        foreach($vars as $key => $value) {
            if(in_array($key, ['id','catid','Itemid'])) {
                $vars[$key] = (int)$value;
            } else {
                $vars[$key] = rawurlencode($value);
            }
        }
        $valid = array_merge($valid,['tmpl','lang','Itemid']);
        $rv = array_filter($vars, function($key) use ($valid) {
            return in_array($key, $valid);
        }, ARRAY_FILTER_USE_KEY);
        return count($rv)?$leading.http_build_query($rv):'';
    }
    public static function queryFromArray($id,$values,$leading='&') {
        $rv = [];
        array_walk($values, function($value, $key) use (&$rv, $id) {
            $rv[$id.'['.$key.']'] = $value;
        });
        return count($rv)?$leading.http_build_query($rv):'';
    }
}