<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\LinkCanonical\Fixes;

use Joomla\Component\Weblinks\Site\Helper\RouteHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonical_com_weblinks extends LinkCanonicalFix {
    public static function fix(&$vars,$uri)
    {
        $valid = ['id','start'];
        if(isset($vars['start']) && (int)$vars['start'] === 0){
            unset($vars['start']);
        }
        $url = false;
        switch($vars['view']){
            case 'weblink':
                $url = 'index.php?option=com_weblinks&view=weblink';
                break;
            case 'category':
                $url = 'index.php?option=com_weblinks&view=category';
                break;
            case 'categories':
                $url = 'index.php?option=com_weblinks&view=categories';
                break;
        }

        // if we have a route and valid extra vars, add the extra vars
        if($url && count($valid)){
            $url .= self::extraVars($vars,$valid);
        }
        
        return $url;
    }
}