<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.linkcanonical
 *
 * @copyright   (C) 2007 Michael Richey <https://www.richeyweb.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\LinkCanonical\Fixes;
use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class LinkCanonicalFix {
    public $prev = 0;
    public $next = 0;
    public static function extraVars($vars,$valid,$leading='&') {
        foreach($vars as $key => $value) {
            if(in_array($key, ['id','catid','Itemid'])) {
                $vars[$key] = (int)$value;
            }
            switch($key){
                case 'tmpl':
                    // tmpl should be all alphanumeric, dash or underscore
                    if(!preg_match('/^[A-Za-z0-9_\-]+$/', (string)$value)) {
                        unset($vars['tmpl']);
                    }
                    break;
                case 'lang':
                    if($value === '*') {
                        break;
                    }
                    // if not *, lang should be 2 alpha characters
                    if(!preg_match('/^[A-Za-z]{2}$/', (string)$value)) {
                        $value = '*';
                    }
            }
            if(isset($valid[$key])) {
                switch($valid[$key]) {
                    case 'int':
                        $vars[$key] = (int)$value;
                        break;
                    case 'float':
                        $vars[$key] = (float)$value;
                        break;
                    case 'bool':
                        $vars[$key] = (bool)$value?1:0;
                        break;
                    case 'string':
                    default:
                        $vars[$key] = urlencode((string)$value);
                }
            }
        }
        $valid = array_merge(array_keys($valid),['tmpl','lang','Itemid']);
        $rv = array_filter($vars, function($key) use ($valid) {
            return in_array($key, $valid);
        }, ARRAY_FILTER_USE_KEY);
        return count($rv)?$leading.http_build_query($rv):'';
    }
    public static function queryFromArray($id,$values,$leading='&') {
        $rv = [];
        array_walk($values, function($value, $key) use (&$rv, $id) {
            $rv[$id.'['.$key.']'] = $value;
        });
        return count($rv)?$leading.http_build_query($rv):'';
    }
    public static function setPagination($pagination,$params=[]) {
        $rv = [];
        $data = $pagination->getData();   
        $rv[] = $data->previous->base??false;
        $rv[] = $data->next->base??false;
        $rv[] = $pagination->pagesCurrent;
        $rv[] = $pagination->pagesTotal*$pagination->limit-$pagination->limit; // this is the max start query param value
        // if keys 0 and 1 are false, return false
        if(!$rv[0] && !$rv[1]) {
            return false;
        }
        if(count($params)){
            $rv[] = $params;
        }
        return $rv;
    }

    public static function getCategoryPaginationObject($modelPath) {
        // investigate: $model = $app->bootComponent(‘com_content’)->getMVCFactory()->createModel(‘Articles’, ‘Administrator’, [‘ignore_request’ => true]);
        $model = new $modelPath();
        $model->getState();
        $items = $model->getItems();
        return $model->getPagination(); 
    }
}