<?php

/**
 * @version		$Id: seblodfeed.php 20196 2011-03-04 02:40:25Z mrichey $
 * @package		plg_system_seblodfeed
 * @copyright	Copyright (C) 2005 - 2011 Michael Richey. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgSystemSeblodFeed extends JPlugin {
    private $_cckparams;
    private $_dispatcher;

    public function onAfterRender() {
        $app = JFactory::getApplication();
        
        // verify that we're dealing with a feed
        if ($app->isAdmin() || $app->input->get('format', false, 'string') != 'feed') return true;

        $body = JResponse::getBody();
        if(!strpos($body,'/cck')) return true;
        
        // it's on!
        $this->_cckparams = JComponentHelper::getParams('plg_system_cck');
        $this->_dispatcher = & JDispatcher::getInstance();
        JPluginHelper::importPlugin('content', 'cck', true, $this->_dispatcher);
        
        // as this portion of the process is identical for both types - create the dom object
        // and pass it to the methods instead of sending the body and duplicating this code
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = true;
        $dom->recover = true;
        $dom->substituteEntities = true;
        $dom->loadXML($body);
        switch ($app->input->get('type', 'rss', 'string')) {
            case 'rss':
                $body = $this->_processRSS($dom);
                break;
            case 'atom':
                $body = $this->_processATOM($dom);
                break;
        }
        JResponse::setBody($body);
    }
    private function _processRSS($dom) {
        foreach(@$dom->getElementsByTagName('item') as $item) {
            foreach ($item->childNodes as $element) {
                if ($element->nodeName != 'description') continue;
                $newText = $dom->createCDATASection($this->_processContent($element->textContent));
                $element->removeChild($element->firstChild);
                $element->appendChild($newText);
            }
        }
        return $dom->saveXML();
    }
    private function _processATOM($dom) {
        foreach(@$dom->getElementsByTagName('entry') as $item) {
            foreach($item->childNodes as $element) {
                if(!in_array($element->nodeName,array('summary','content'))) continue;
                $newText = new DOMText($this->_processContent($element->textContent));
                $element->removeChild($element->firstChild);
                $element->appendChild($newText);
            }
        }
        return($dom->saveXML());
    }
    private function _processContent($input) {
        $object = new JObject;
        $object->text = $input;
        $result = $this->_dispatcher->trigger('onContentPrepare', array('com_content.category', &$object, &$this->_cckparams, 0));
        unset($result);
        return $object->text;
    }
}