var plg_system_sessionkeeperAlertClass = function(options) {
    var root = this;
    root.options = options;
    root.Text = Joomla.Text; // Updated: direct access, no window.Joomla.Text needed in modern Joomla
    root.currentAlert = null; // Track the current joomla-alert element

    this.showWarning = function() {
        Joomla.removeMessages(); // Clear any prior messages

        var cancel = root.buildButton(root.Text._('JCANCEL'), 'cancel btn btn-sm btn-danger float-end');
        var renew = root.buildButton(root.Text._('PLG_SYSTEM_SESSIONKEEPER_RESCUE'), 'renew btn btn-sm btn-success me-2 float-end');

        var messageHtml = root.Text._('PLG_SYSTEM_SESSIONKEEPER_WARNINGMESSAGE')
            .replace('%s', root.options.timeout) + ' <span class="text-monospace"></span>';

        var message = root.buildMessage(messageHtml, [cancel, renew]);

        var messageObject = { warning: [message.outerHTML] }; // 'warning' type for yellow alert

        Joomla.renderMessages(messageObject);

        root.currentAlert = root.getAlert();
        if (root.currentAlert) {
            root.prepareAlert(root.currentAlert);

            root.currentAlert.querySelector('.cancel').addEventListener('click', function() {
                Joomla.removeMessages();
                // No warningClosed() call needed – timer continues until expire or renew
            });

            root.currentAlert.querySelector('.renew').addEventListener('click', function() {
                console.log('Renewing session');
                window.SessionKeeper.renewSession(); // New global, routes to worker
                // Don't remove messages here – wait for worker 'closeWarning' broadcast
            });

            // Countdown target
            var countdownTarget = root.currentAlert.querySelector('div.sessionkeeper-alert span');
            if (countdownTarget) {
                countdownTarget.classList.add('text-monospace');
                // Clear any old listener if re-shown
                window.removeEventListener('SessionKeeperCountdown', root.updateCountdown);
                window.addEventListener('SessionKeeperCountdown', root.updateCountdown);
                root.countdownTarget = countdownTarget;
            }
        }
    };

    this.updateCountdown = function(e) {
        if (root.countdownTarget) {
            if (e.detail.formatted) {
                root.countdownTarget.innerHTML = e.detail.formatted;
            } else {
                // Fallback padding
                root.countdownTarget.innerHTML =
                    e.detail.h + ':' +
                    String(e.detail.m).padStart(2, '0') + ':' +
                    String(e.detail.s).padStart(2, '0');
            }
        }
    };

    this.showExpired = function() {
        Joomla.removeMessages();

        var cancel = root.buildButton(root.Text._('JCANCEL'), 'cancel btn btn-sm btn-danger float-end');

        var messageHtml = root.Text._('PLG_SYSTEM_SESSIONKEEPER_EXPIREDMESSAGE');

        var message = root.buildMessage(messageHtml, [cancel]);

        var messageObject = { error: [message.outerHTML] }; // 'error' type for red alert

        Joomla.renderMessages(messageObject);

        root.currentAlert = root.getAlert();
        if (root.currentAlert) {
            root.prepareAlert(root.currentAlert);

            root.currentAlert.querySelector('.cancel').addEventListener('click', function() {
                root.currentAlert.close(); // Or Joomla.removeMessages() if close() not available
                if (root.options.redirect) {
                    window.location.href = root.options.redirect;
                } else {
                    window.location.reload();
                }
            });
        }
    };

    // New: called by worker after successful renew
    this.closeWarning = function() {
        Joomla.removeMessages();
        window.removeEventListener('SessionKeeperCountdown', root.updateCountdown);
    };

    this.getAlert = function() {
        var sessionkeeperDiv = document.querySelector('div.sessionkeeper-alert');
        return sessionkeeperDiv ? sessionkeeperDiv.closest('joomla-alert') : null;
    };

    this.prepareAlert = function(alert) {
        // Your original – likely removes default close button to avoid conflicts
        if (typeof alert.destroyCloseButton === 'function') {
            alert.destroyCloseButton();
        }
    };

    this.buildMessage = function(text, buttons) {
        var row = document.createElement('div');
        buttons.forEach(function(button) {
            row.appendChild(button);
        });
        var div = document.createElement('div');
        div.className = 'sessionkeeper-alert';
        div.innerHTML = text;
        row.appendChild(div);
        return row;
    };

    this.buildButton = function(text, classes) {
        var button = document.createElement('button');
        button.type = 'button';
        button.className = classes;
        button.innerHTML = text;
        return button;
    };
};

// Init: register with the new client (load after sessionkeeper-main.js)
// This runs immediately when the script is parsed
(function() {
    const registerHandler = () => {
        if (!window.SessionKeeper?.options) return;

        const handler = new plg_system_sessionkeeperAlertClass(window.SessionKeeper.options);

        window.SessionKeeper.uiHandler = {
            showWarning: () => handler.showWarning(),
            showExpired: () => handler.showExpired(),
            closeWarning: () => handler.closeWarning?.()
        };

        console.log('[SessionKeeper] Alert handler registered');
    };

    // Listen for the ready event (future or past)
    window.addEventListener('SessionKeeperReady', registerHandler);

    // If main already ran and fired the event before this script loaded
    if (window.SessionKeeper) {
        registerHandler();
    }
})();