var plg_system_sessionkeeperConfirmClass = function(options) {
    var root = this;
    root.options = options;
    root.Text = Joomla.Text; // Direct access (modern Joomla)

    this.showWarning = function() {
        var message = root.htmlEntities(
            root.Text._('PLG_SYSTEM_SESSIONKEEPER_CONFIRMWARNINGMESSAGE')
        ).replace('%s', root.options.timeout);

        var response = confirm(message);

        if (response) {
            // Trigger renewal via the new client
            window.SessionKeeper.renewSession();
            // Note: No UI to close, but worker will reset timers
        }
        // If user cancels, do nothing — timer continues toward expire
    };

    this.showExpired = function() {
        var message = root.htmlEntities(
            root.Text._('PLG_SYSTEM_SESSIONKEEPER_EXPIREDMESSAGE')
        );
        alert(message);

        // Perform redirect/reload
        if (root.options.redirect) {
            window.location.href = root.options.redirect;
        } else {
            window.location.reload();
        }
    };

    this.htmlEntities = function(str) {
        var p = document.createElement('p');
        p.textContent = str;
        return p.innerHTML;
    };

    // Optional: closeWarning does nothing for confirm type
    this.closeWarning = function() {
        // No persistent UI to close
    };
};

// Init: register with the new SessionKeeperClient
// This runs immediately when the script is parsed
(function() {
    const registerHandler = () => {
        if (!window.SessionKeeper?.options) return;

        const handler = new plg_system_sessionkeeperConfirmClass(window.SessionKeeper.options);

        window.SessionKeeper.uiHandler = {
            showWarning: () => handler.showWarning(),
            showExpired: () => handler.showExpired(),
            closeWarning: () => handler.closeWarning?.()
        };

        console.log('[SessionKeeper] Confirm handler registered');
    };

    // Listen for the ready event (future or past)
    window.addEventListener('SessionKeeperReady', registerHandler);

    // If main already ran and fired the event before this script loaded
    if (window.SessionKeeper) {
        registerHandler();
    }
})();