var plg_system_sessionkeeperDialogClass = function(options) {
    var root = this;
    root.options = options;
    root.Text = Joomla.Text; // Direct access for modern Joomla
    root.dialogs = {};
    root.countdownTarget = null;

    var construct = function() {
        root.dialogs.warning = document.getElementById('plg_system_sessionkeeper_warning');
        root.dialogs.expired = document.getElementById('plg_system_sessionkeeper_expired');

        if (!root.dialogs.warning || !root.dialogs.expired) {
            console.warn('SessionKeeper: Dialog elements not found');
            return;
        }

        root.listeners();
    };

    this.showWarning = function() {
        root.dialogs.warning.showModal();
        root.countdownTarget = root.dialogs.warning.querySelector('p span');
        if (root.countdownTarget) {
            root.countdownTarget.classList.add('text-monospace');
            // Clear old listener if re-shown
            window.removeEventListener('SessionKeeperCountdown', root.updateCountdown);
            window.addEventListener('SessionKeeperCountdown', root.updateCountdown);
        }
    };

    this.updateCountdown = function(e) {
        if (root.countdownTarget) {
            if (e.detail.formatted) {
                root.countdownTarget.innerHTML = e.detail.formatted;
            } else {
                // Fallback padding
                root.countdownTarget.innerHTML =
                    e.detail.h + ':' +
                    String(e.detail.m).padStart(2, '0') + ':' +
                    String(e.detail.s).padStart(2, '0');
            }
        }
    };

    this.showExpired = function() {
        root.dialogs.warning.close();
        // No warningClosed() call needed
        root.dialogs.expired.showModal();
    };

    this.listeners = function() {
        // Close button on warning (cancel)
        root.dialogs.warning.querySelector('.close').addEventListener('click', function() {
            root.dialogs.warning.close();
            // No warningClosed() – let timer continue
        });

        // Renew button on warning
        root.dialogs.warning.querySelector('.renew').addEventListener('click', function() {
            root.dialogs.warning.close();
            window.SessionKeeper.renewSession(); // New global, routes to worker
        });

        // Close button on expired
        root.dialogs.expired.querySelector('.close').addEventListener('click', function() {
            root.dialogs.expired.close();
            if (root.options.redirect) {
                window.location.href = root.options.redirect;
            } else {
                window.location.reload();
            }
        });
    };

    // New: called by worker after successful renew (optional close if needed)
    this.closeWarning = function() {
        if (root.dialogs.warning && root.dialogs.warning.hasAttribute('open')) {
            root.dialogs.warning.close();
        }
        window.removeEventListener('SessionKeeperCountdown', root.updateCountdown);
    };

    construct();
};

// Init: register with the new SessionKeeperClient
// This runs immediately when the script is parsed
(function() {
    const registerHandler = () => {
        if (!window.SessionKeeper?.options) return;

        const handler = new plg_system_sessionkeeperDialogClass(window.SessionKeeper.options);

        window.SessionKeeper.uiHandler = {
            showWarning: () => handler.showWarning(),
            showExpired: () => handler.showExpired(),
            closeWarning: () => handler.closeWarning?.()
        };

        console.log('[SessionKeeper] Dialog handler registered');
    };

    // Listen for the ready event (future or past)
    window.addEventListener('SessionKeeperReady', registerHandler);

    // If main already ran and fired the event before this script loaded
    if (window.SessionKeeper) {
        registerHandler();
    }
})();