var plg_system_sessionkeeperEventClass = function(options) {
    var root = this;

    // No options needed – this handler is purely event dispatch
    this.showWarning = function() {
        window.dispatchEvent(new CustomEvent('SessionKeeperWarning'));
    };

    this.showExpired = function() {
        window.dispatchEvent(new CustomEvent('SessionKeeperExpired'));
    };

    // Optional: if someone wants to react to post-renew cleanup
    this.closeWarning = function() {
        // No UI to close, but we can fire an optional event if desired
        window.dispatchEvent(new CustomEvent('SessionKeeperRenewed'));
    };
};

// Init: register with the new SessionKeeperClient
// This runs immediately when the script is parsed
(function() {
    const registerHandler = () => {
        if (!window.SessionKeeper?.options) return;

        const handler = new plg_system_sessionkeeperEventClass(window.SessionKeeper.options);

        window.SessionKeeper.uiHandler = {
            showWarning: () => handler.showWarning(),
            showExpired: () => handler.showExpired(),
            closeWarning: () => handler.closeWarning?.()
        };

        console.log('[SessionKeeper] Event handler registered');
    };

    // Listen for the ready event (future or past)
    window.addEventListener('SessionKeeperReady', registerHandler);

    // If main already ran and fired the event before this script loaded
    if (window.SessionKeeper) {
        registerHandler();
    }
})();