var plg_system_sessionkeeperModalClass = function(options) {
    var root = this;
    root.options = options;
    root.elements = {};
    root.dialogs = {};

    var construct = function() {
        root.elements.warning = document.getElementById('plg_system_sessionkeeper_warning');
        root.elements.expired = document.getElementById('plg_system_sessionkeeper_expired');

        if (!root.elements.warning || !root.elements.expired) {
            console.warn('SessionKeeper: Modal elements not found');
            return;
        }

        var modalOptions = { backdrop: 'static', keyboard: false };
        root.dialogs.warning = bootstrap.Modal.getOrCreateInstance(root.elements.warning, modalOptions);
        root.dialogs.expired = bootstrap.Modal.getOrCreateInstance(root.elements.expired, modalOptions);

        root.elements.countdownTarget = root.elements.warning.querySelector('div.modal-body p span');

        // Listen for formatted countdown from worker
        window.addEventListener('SessionKeeperCountdown', function(e) {
            if (e.detail.formatted) {
                root.elements.countdownTarget.innerHTML = e.detail.formatted;
            } else {
                // Fallback if only raw {h,m,s}
                root.elements.countdownTarget.innerHTML =
                    e.detail.h + ':' +
                    String(e.detail.m).padStart(2, '0') + ':' +
                    String(e.detail.s).padStart(2, '0');
            }
        });

        // "Stay logged in" button
        root.elements.warning.querySelector('.renew').addEventListener('click', function() {
            window.SessionKeeper.renewSession(); // New capital S global
            root.dialogs.warning.hide();
        });

        // Optional: notify worker if warning closed without renew (e.g., ESC pressed)
        root.elements.warning.addEventListener('hide.bs.modal', function() {
            // Only call if not renewing — but we don't know intent here
            // So maybe don't call warningClosed() anymore, or make it optional
        });

        // Expired modal closed → redirect/reload
        root.elements.expired.addEventListener('hide.bs.modal', function() {
            if (root.options.redirect) {
                window.location.href = root.options.redirect;
            } else {
                window.location.reload();
            }
        });
    };

    this.showWarning = function() {
        root.dialogs.warning.show();
    };

    this.showExpired = function() {
        root.dialogs.warning.hide();
        root.dialogs.expired.show();
    };

    // Optional: expose close if worker wants to force-close after renew
    this.closeWarning = function() {
        root.dialogs.warning.hide();
    };

    construct();
};

// Updated init: wait for DOM + our new client
// This runs immediately when the script is parsed
(function() {
    const registerHandler = () => {
        if (!window.SessionKeeper?.options) return;

        const handler = new plg_system_sessionkeeperModalClass(window.SessionKeeper.options);

        window.SessionKeeper.uiHandler = {
            showWarning: () => handler.showWarning(),
            showExpired: () => handler.showExpired(),
            closeWarning: () => handler.closeWarning?.()
        };

        console.log('[SessionKeeper] Modal handler registered');
    };

    // Listen for the ready event (future or past)
    window.addEventListener('SessionKeeperReady', registerHandler);

    // If main already ran and fired the event before this script loaded
    if (window.SessionKeeper) {
        registerHandler();
    }
})();