class SessionKeeperClient{constructor(){this.options=Joomla.getOptions("plg_system_sessionkeeper");if(!this.options){console.warn("SessionKeeper: No options found");return}this.Text=Joomla.Text;this.uiHandler=null;this.worker=null;this.port=null;this.broadcast=null;this.setupActivityDetection();this.initWorker();window.SessionKeeper=this;window.dispatchEvent(new CustomEvent("SessionKeeperReady",{detail:{client:this}}))}setupActivityDetection(){(function(){const originalOpen=XMLHttpRequest.prototype.open;XMLHttpRequest.prototype.open=function(method,url){this.addEventListener("loadend",function(){if(this.responseURL){window.dispatchEvent(new CustomEvent("SessionKeeperXHROpen",{detail:this.responseURL}))}});originalOpen.apply(this,arguments)}})();const observer=new PerformanceObserver(list=>{for(const entry of list.getEntries()){if(entry.initiatorType==="fetch"||entry.initiatorType==="xmlhttprequest"){window.dispatchEvent(new CustomEvent("SessionKeeperXHROpen",{detail:entry.name}))}}});observer.observe({entryTypes:["resource"]});window.addEventListener("SessionKeeperXHROpen",e=>{this.reportActivity(e.detail)});window.addEventListener("unload",()=>{observer.disconnect()})}reportActivity(url){try{const parsed=new URL(url,location.href);if(parsed.hostname!==location.hostname)return;console.log("[SessionKeeper] Activity reported from: "+url);this.port.postMessage({type:"activity"});if(!this.isShared&&this.broadcast){this.broadcast.postMessage("activity")}}catch(err){}}initWorker(){const paths=Joomla.getOptions("system.paths")||{};const rootFull=paths.rootFull||window.location.origin+"/";const base=rootFull.replace(/\/$/,"");const workerUrl=base+"/media/plg_system_sessionkeeper/js/worker.js";if("SharedWorker"in window){try{this.worker=new SharedWorker(workerUrl,"SessionKeeperSharedWorker");this.port=this.worker.port;this.port.onmessage=e=>this.handleCommand(e.data);this.port.start();this.isShared=true;this.port.postMessage({type:"init",options:this.options});console.log("[SessionKeeper] SharedWorker loaded")}catch(err){console.warn("[SessionKeeper] SharedWorker failed, falling back:",err);this.setupDedicatedWithBroadcast(workerUrl)}}else{console.log("[SessionKeeper] No SharedWorker support, using dedicated + BroadcastChannel");this.setupDedicatedWithBroadcast(workerUrl)}console.log("%c[SessionKeeper] Using "+(this.isShared?"SharedWorker":"Dedicated Worker + BroadcastChannel"),"color: #2196F3; font-weight: bold;");this.startHeartbeat()}startHeartbeat(){if(this.heartbeatTimer){clearInterval(this.heartbeatTimer)}const heartbeatInterval=3e4;let lastPong=Date.now();const currentHandler=this.port.onmessage;this.port.onmessage=e=>{if(currentHandler){currentHandler.call(this.port,e)}if(e.data&&e.data.type==="pong"){lastPong=Date.now()}};const heartbeat=()=>{if(Date.now()-lastPong>6e4){console.warn("[SessionKeeper] Worker unresponsive - restarting");this.initWorker();return}this.port.postMessage({type:"ping"})};this.heartbeatTimer=setInterval(heartbeat,heartbeatInterval);heartbeat();window.addEventListener("unload",()=>clearInterval(this.heartbeatTimer))}setupDedicatedWithBroadcast(workerUrl){this.worker=new Worker(workerUrl,{name:"SessionKeeperDedicatedWorker"});this.port=this.worker;this.isShared=false;this.broadcast=new BroadcastChannel("sessionkeeper_sync");this.broadcast.onmessage=e=>{if(e.data==="activity"||e.data==="renew_success"){this.port.postMessage({type:e.data==="activity"?"activity":"renew"})}}}handleCommand(cmd){switch(cmd.type){case"showWarning":this.uiHandler.showWarning?.();break;case"showExpired":this.uiHandler.showExpired?.();break;case"closeWarning":this.uiHandler.closeWarning?.();break;case"countdown":window.dispatchEvent(new CustomEvent("SessionKeeperCountdown",{detail:cmd.time}));break;case"redirect":setTimeout(()=>{if(this.options.redirect){location.href=this.options.redirect}else{location.reload()}},6e4);break;case"status":if(this.options.debug){console.log("%c[SessionKeeper Worker] "+cmd.message,"color: #4CAF50; font-weight: bold;")}break}}renewSession(){this.port.postMessage({type:"renew"});if(!this.isShared&&this.broadcast){this.broadcast.postMessage("activity")}}}(function(){const originalSend=XMLHttpRequest.prototype.send;XMLHttpRequest.prototype.send=function(){const xhr=this;const oldCallback=xhr.onreadystatechange;xhr.onreadystatechange=function(){if(xhr.readyState===4&&xhr.responseURL){const evt=new CustomEvent("SessionKeeperXHROpen",{detail:xhr.responseURL});window.dispatchEvent(evt)}if(oldCallback){oldCallback.apply(xhr,arguments)}};return originalSend.apply(xhr,arguments)}})();window.addEventListener("DOMContentLoaded",function(){if(!window.SessionKeeper){new SessionKeeperClient;window.SessionKeeper.reportActivity(document.location.href);(function(){if(!window.fetch)return;const originalFetch=window.fetch;window.fetch=function(resource,init){let url=typeof resource==="string"?resource:resource.url||"";if(url.includes("option=com_ajax")||url.includes("format=json")){if(window.SessionKeeper?.port){window.dispatchEvent(new CustomEvent("SessionKeeperXHROpen",{detail:url}))}}return originalFetch.apply(this,arguments)};console.log("[SessionKeeper] Native fetch hooked for keepalive detection")})()}});