class SessionKeeperCore{constructor(){this.options=null;this.warningTimeout=null;this.expiredTimeout=null;this.countdownInterval=null;this.countdownTarget=null;this.ports=new Set}s2hms(seconds){if(seconds<0)seconds=0;const h=Math.floor(seconds/3600);seconds%=3600;const m=Math.floor(seconds/60);const s=Math.floor(seconds%60);return{h:h,m:m,s:s}}zeroPad(num,places=2){return String(num).padStart(places,"0")}getRemainingWarningSeconds(){if(!this.countdownTarget)return 0;const diff=(this.countdownTarget.getTime()-Date.now())/1e3;return Math.max(0,diff)}init(options){this.options=options;this.status("Worker initialized with timeout: "+options.timeout+" min, warning: "+options.warning+" min");this.resetTimers()}resetTimers(){clearTimeout(this.warningTimeout);clearTimeout(this.expiredTimeout);clearInterval(this.countdownInterval);this.status("Timers reset - next warning in "+(this.options.timeout-this.options.warning)+" min");const warnDelay=(this.options.timeout-this.options.warning)*6e4;const expireDelay=this.options.timeout*6e4;this.warningTimeout=setTimeout(()=>this.triggerWarning(),warnDelay);this.expiredTimeout=setTimeout(()=>this.triggerExpired(),expireDelay)}triggerWarning(){this.startCountdown();this.status("Warning triggered - showing UI");this.broadcast({type:"showWarning"})}triggerExpired(){clearInterval(this.countdownInterval);this.status("Session expired - showing expired UI");this.broadcast({type:"showExpired"});setTimeout(()=>this.broadcast({type:"redirect"}),5e3)}startCountdown(){const now=Date.now()+this.options.warning*6e4;this.countdownTarget=new Date(now);this.countdownInterval=setInterval(()=>{const secs=this.getRemainingWarningSeconds();const time=this.s2hms(secs);this.broadcast({type:"countdown",time:time,formatted:`${this.zeroPad(time.h)}:${this.zeroPad(time.m)}:${this.zeroPad(time.s)}`});if(secs<=0){clearInterval(this.countdownInterval)}},1e3)}async renewSession(){this.status("Attempting session renewal...");const maxRetries=4;let attempt=0;while(attempt<maxRetries){try{const response=await fetch(this.options.renewurl,{method:"GET",credentials:"same-origin",headers:{"X-Requested-With":"XMLHttpRequest",Accept:"application/json"}});if(!response.ok)throw new Error(`HTTP ${response.status}`);await response.json();this.status("Session successfully renewed");this.resetTimers();this.broadcast({type:"closeWarning"});return}catch(err){attempt++;this.status(`Renew attempt ${attempt} failed: ${err.message}`);if(attempt>=maxRetries){this.status("All renew attempts failed");this.broadcast({type:"renewFailed"});return}const delay=1e3*Math.pow(2,attempt-1)+Math.random()*1e3;await new Promise(resolve=>setTimeout(resolve,delay))}}}broadcast(message){if(this.ports.size>0){this.ports.forEach(port=>port.postMessage(message))}else{postMessage(message)}}status(msg){this.broadcast({type:"status",message:msg})}handleMessage(msg,port){switch(msg.type){case"init":this.init(msg.options);break;case"activity":this.status("Activity detected - resetting timers: "+msg.url);this.resetTimers();this.broadcast({type:"closeWarning"});break;case"renew":this.renewSession();break;case"ping":this.broadcast({type:"pong"});break}}}const core=new SessionKeeperCore;self.onconnect=e=>{console.log("[SessionKeeper Worker] onconnect fired!");const port=e.ports[0];core.ports.add(port);port.start();port.postMessage({type:"status",message:"SharedWorker connected - port open"});port.onmessage=msg=>core.handleMessage(msg.data,port);port.onclose=()=>core.ports.delete(port)};if(typeof SharedWorkerGlobalScope==="undefined"||!(self instanceof SharedWorkerGlobalScope)){self.postMessage({type:"status",message:"Dedicated Worker started"});onmessage=e=>core.handleMessage(e.data)}else{}