<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.metarobots
 *
 * @copyright   (C) 2007 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\TopOfThePage\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
final class TopOfThePage extends CMSPlugin
{

    /**
     * Load the language file on instantiation.
     *
     * @var    bool
     * @since  4.4.0
     */
    protected $autoloadLanguage = true;

    public function onBeforeCompileHead()
    {
        $app = Factory::getApplication();
        if(!$app->isClient('site') && !$this->params->get('runinadmin',0)) {
            return;
        }
        $doc = $app->getDocument();
        if($doc->getType() !== 'html') {
            return;
        }
        $debug = (bool)$app->get('debug', 0)?'':'.min';
        $wa = $doc->getWebAssetManager();
        $wa->registerAndUseStyle('System - Top Of The Page (https://www.richeyweb.com)', 'media/plg_system_topofthepage/css/topofthepage'.$debug.'.css', ['version' => 'auto']);
        $wa->registerAndUseScript('System - Top Of The Page (https://www.richeyweb.com)', 'media/plg_system_topofthepage/js/topofthepage'.$debug.'.js', ['version' => 'auto'], ['defer' => true, 'async'=>true]);
        $doc->addScriptOptions('plg_system_topofthepage',$this->_loadJSOptions());

        if($this->params->get('usestyle',0)){
            $doc->addStyleDeclaration($this->params->get('linkstyle',''));
        }
    }

    private function _loadJSOptions($framework = 'mootools') 
    {
        $options = array(
            'displaydur' => ['int',250],
            'spyposition' => ['int',200],
            'visibleopacity' => ['int',100],
            'slidein' => ['bool',0],
            'slideindir' => ['string','top'],
            'zindex' => ['int',0],
            'omittext' => ['bool',0],
            'smoothscroll' => ['bool',1],
        );
        
        foreach ($options as $option => $default) {
            switch($default[0]) {
                case 'int':
                    $options[$option] = (integer)$this->params->get($option, $default[1]);
                    break;
                case 'bool':
                    $options[$option] = (bool)$this->params->get($option, $default[1]);
                    break;
                case 'string':
                    $options[$option] = strlen(trim($this->params->get($option, $default[1]))) ? trim($this->params->get($option, $default[1])) : false;
                    break;
            }
        }
        Text::script('PLG_SYSTEM_TOPOFTHEPAGE_GOTOTOP');
        $options['topalways'] = ($this->params->get('topalways', 0)) ? true : false;

        $options['icon'] = strlen(trim($this->params->get('icon', false))) ? trim($this->params->get('icon', false)) : false;

        $options['buttontext'] = Text::_('PLG_SYSTEM_TOPOFTHEPAGE_GOTOTOP');
        
        $options['buttonclass'] = $this->params->get('buttonclass', '');

        $options['buttonposition'] = [$this->params->get('buttonvlocation', 'bottom'), $this->params->get('buttonhlocation', 'right')];
        
        return $options;
    }
}