<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\XAutopost\XMetas;

\defined('_JEXEC') or die;

use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;

class XMeta {
    protected $app;
    protected $articleCard;
    protected $defaultCard;
    protected $article;
    public $type;
    protected $validCardTypes = ['summary','summary_large_image','app','player'];
    public $map = [
        'summary'=>['site','site_id','description','title','image','image_alt'],
        'summary_large_image'=>['site','site_id','creator','creator_id','description','title','image','image_alt'],
        'app'=>['site','site_id','description','title','image','image_alt','app_country','app_name_iphone','app_id_iphone','app_url_iphone','app_name_ipad','app_id_ipad','app_url_ipad','app_name_googleplay','app_id_googleplay','app_url_googleplay'],
        'player'=>['site','site_id','description','title','image','image_alt','player','player_width','player_height','player_stream'],
    ];
    public $names = [
        'site'=>'twitter:site',
        'site_id'=>'twitter:site:id',
        'creator'=>'twitter:creator',
        'creator_id'=>'twitter:creator:id',
        'description'=>'twitter:description',
        'title'=>'twitter:title',
        'image'=>'twitter:image',
        'image_alt'=>'twitter:image:alt',
        'app_country'=>'twitter:app:country',
        'app_name_iphone'=>'twitter:app:name:iphone',
        'app_id_iphone'=>'twitter:app:id:iphone',
        'app_url_iphone'=>'twitter:app:url:iphone',
        'app_name_ipad'=>'twitter:app:name:ipad',
        'app_id_ipad'=>'twitter:app:id:ipad',
        'app_url_ipad'=>'twitter:app:url:ipad',
        'app_name_googleplay'=>'twitter:app:name:googleplay',
        'app_id_googleplay'=>'twitter:app:id:googleplay',
        'app_url_googleplay'=>'twitter:app:url:googleplay',
        'player'=>'twitter:player',
        'player_width'=>'twitter:player:width',
        'player_height'=>'twitter:player:height',
        'player_stream'=>'twitter:player:stream'
    ];

    public function __construct($twittercard,$article,$params) {
        $this->app = Factory::getApplication();
        $this->article = $article;
        if($params instanceof Registry){
            $this->defaultCard = $params;
        } else {
            $this->defaultCard = new Registry($params);
        }
        if($twittercard instanceof Registry){
            $this->articleCard = $twittercard;
        } else {
            $this->articleCard = new Registry($twittercard);
        }
        $this->type = $this->getType();
    }

    private function getType(){
        $articleType = $this->articleCard->get('card_type','default');
        $defaultType = $this->defaultCard->get('card_type','summary');

        if($articleType === 'default'){
            return $defaultType?:'summary';
        }
        return $articleType;
    }

    public function getMetaTags() {
        if(!in_array($this->type,$this->validCardTypes)){
            $this->type = 'summary';
        }
        $metas = [];
        foreach($this->map[$this->type] as $meta){
            $result = $this->{'get'.ucfirst($meta)}();
            if($result !== false){
                $metas[$meta] = ['name'=>(string)$this->names[$meta],'content'=>(string)$result];
            }
        }
        $minimum = true;
        switch($this->type){
            // case 'summary':
            //     $minimum = $this->checkSummary($metas);
            //     break;
            // case 'summary_large_image':
            //     $minimum = $this->checkSummaryLargeImage($metas);
            //     break;
            case 'summary':
            case 'summary_large_image':
                break;
            case 'app':
                $minimum = $this->checkApp($metas);
                break;
            case 'player':
                $minimum = $this->checkPlayer($metas);
                break;
            default:
                $minimum = false; // should not happen
                break;
        }
        
        if(!$minimum){
            return false;
        }

        return [['name'=>'twitter:card','content'=>$this->type]] + $metas;
    }

    // private function checkSummary($metas){
    //     $minimum = ['site','description','title'];
    //     return $this->checkMinimum($metas,$minimum);
    // }

    // private function checkSummaryLargeImage($metas){
    //     $minimum = ['site','description','title','image'];
    //     return $this->checkMinimum($metas,$minimum);
    // }

    private function checkPlayer(&$metas){
        // $minimum = ['site','description','title','image','player_width','player_height'];
        $minimum = ['player_width','player_height'];
        if(!$this->checkMinimum($metas,$minimum)){
            return false;
        }
        // must have player or stream
        if(!isset($metas['player']) && !isset($metas['player_stream'])){
            return false;
        }
        // if stream is present, inject twitter:player:stream:content_type meta
        if(!empty($metas['player_stream']) && !isset($metas['stream:content_type'])){
            $url = $metas['player_stream']['content'];
            // we must guess the mime type from the url
            // this is not foolproof, but better than nothing
            // we could use get_headers() but that would be slow
            // we only want the path part of the URL
            $urlParts = parse_url($url);
            if(!isset($urlParts['path'])){
                return false;
            }
            $path = $urlParts['path'];
            $ext = strtolower(pathinfo($path,PATHINFO_EXTENSION));
            $mimetype = false;
            // the only safe content is mp4, mp3, and m4a
            // anything else is likely to be unsupported by twitter
            // or potentially dangerous
            // see https://developer.twitter.com/en/docs/twitter-for-websites/cards/overview/player-card
            switch($ext){
                case 'mp4':
                case 'm4v':
                    $mimetype = 'video/mp4';
                    break;
                case 'mp3':
                    $mimetype = 'audio/mpeg';
                    break;
                case 'm4a':
                case 'm4b':
                    $mimetype = 'audio/aac';
                    break;
            }

            if(!$mimetype){
                return false;
            }
            $meta = ['name'=>'twitter:player:stream:content_type','content'=>$mimetype];
            if(filter_var($url, FILTER_VALIDATE_URL)){
                $metas['stream_content_type'] = $meta;
                return true;
            }
            if(!file_exists(JPATH_ROOT.'/'.$url)){
                return false;
            }
            if(!isset($metas['player'])){
                $metas['stream_content_type'] = $meta;
                $playerUrl = 'index.php?option=com_ajax&plugin=xautopost&format=raw&id='.$this->articleCard->get('xautopost_id');
                $metas['player'] = ['name'=>'twitter:player','content'=>$this->getBaseUrl().ltrim(Route::_($playerUrl,false),'/')];
            }
        }
        return true;
    }

    private function checkApp($metas){
        // $minimum = ['site','description','title','image','app_country'];
        $minimum = ['app_country'];
        if(!$this->checkMinimum($metas,$minimum)){
            return false;
        }
        foreach(['iphone','ipad','googleplay'] as $platform){
            $nameKey = 'app_name_'.$platform;
            $idKey = 'app_id_'.$platform;
            // $urlKey = 'app_url_'.$platform; // url is optional
            if(isset($metas[$nameKey]) && isset($metas[$idKey])){
                return true;
            }
        }
        return false;
    }

    private function checkMinimum($metas,$minimum) {
        foreach($minimum as $item){
            if(!isset($metas[$item])){
                return false;
            }
        }
        return true;
        // if all items in minimum are arrays, then one of the arrays must be fully present
        // $allArrays = false;
        // $someArrays = false;
        // $arrays = 0;
        // $strings = 0;
        // foreach($minimum as $item){
        //     if(is_array($item)){
        //         $arrays++;
        //     } else {
        //         $strings++;
        //     }
        // }
        // if($arrays && !$strings){
        //     $allArrays = true;
        // }
        // if($arrays && $strings){
        //     $someArrays = true;
        // }

        // foreach($minimum as $item){
        //     if($allArrays){
        //         // any of the array items must be fully present
        //         $length = count($item);
        //         $intersect = array_intersect(array_keys($metas),$item);
        //         if(count($intersect) !== $length){
        //             return false;
        //         }
        //     } else {
        //         if($someArrays && is_array($item)){
        //             // any array item present is sufficient
        //             $found = false;
        //             foreach($item as $subitem){
        //                 if(isset($metas[$subitem])){
        //                     $found = true;
        //                     break;
        //                 }
        //             }
        //             if(!$found){
        //                 return false;
        //             }
        //         } else {
        //             if(!isset($metas[$item])){
        //                 return false;
        //             }
        //         }
        //     }
        // }
        // return true;
    }

    protected function getSite() {
        $option = $this->articleCard->get('site_option','default');

        if($option !== 'default'){
            return $this->articleCard->get('site',$this->defaultCard->get('site',false));
        }
        return $this->defaultCard->get('site',false);
    }
    protected function getSite_id() {
        $option = $this->articleCard->get('site_id_option','default');
        if($option !== 'default'){
            return $this->articleCard->get('site_id',$this->defaultCard->get('site_id',false));
        }
        return $this->defaultCard->get('site_id',false);
    }
    protected function getCreator() {
        $option = $this->articleCard->get('creator_option','default');
        if($option !== 'default'){
            return $this->articleCard->get('creator',$this->defaultCard->get('creator',false));
        }
        return $this->defaultCard->get('creator',false);
    }
    protected function getCreator_id() {
        $option = $this->articleCard->get('creator_id_option','default');
        if($option !== 'default'){
            return $this->articleCard->get('creator_id',$this->defaultCard->get('creator_id',false));
        }
        return $this->defaultCard->get('creator_id',false);
    }

    protected function getImage(){
        $imagePath = $this->getImagePath();
        // if the image path is already a full URL, return it
        if(filter_var($imagePath,FILTER_VALIDATE_URL)){
            return $imagePath;
        }
        
        // now we prepend the base url
        $base = $this->getBaseUrl();
        return $base.ltrim($imagePath,'/');
    }

    protected function getBaseUrl(){
        return rtrim(Uri::base(),'/').'/';
    }

    protected function validImage($image){
        $validExt = ['jpg','jpeg','png','gif','webp'];
        $ext = strtolower(pathinfo($image,PATHINFO_EXTENSION));
        if(in_array($ext,$validExt)){
            return true;
        }
        return false;
    }

    protected function articleImage($html){
        if(empty($html)){
            return false;
        }
        $doc = new \DOMDocument();
        @$doc->loadHTML($html);
        $tags = $doc->getElementsByTagName('img');
        foreach ($tags as $tag) {
            $src = $tag->getAttribute('src');
            if($this->validImage($src)){
                return $src;
            }
        }
        return false;
    }

    protected function compressTrimText($text,$length=200){
        // remove newlines and consecutive spaces
        $text = preg_replace('/\s+/',' ',trim($text));
        if(strlen($text??'') > $length){
            $text = substr($text,0,$length);
            $lastspace = strrpos($text,' ');
            if($lastspace !== false){
                $text = substr($text,0,$lastspace);
            }
        }
        return $text;
    }
}