<?php

/**
 * @copyright   Copyright (C) 2005 - 2013 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace RicheyWeb\Plugin\System\XAutopost\XMetas;

\defined('_JEXEC') or die;

class XMeta_com_contact extends XMeta {
    protected $validCardTypes = ['summary','summary_large_image'];
    // public function __construct($article, $articleCard, $defaultCard) {
    //     parent::__construct($article, $articleCard, $defaultCard);
    //     // contact can only be summary or summary_large_image
    //     if(!in_array($this->type,$this->validCardTypes)){
    //         $this->type = 'summary';
    //     }
    // }
    protected function getDescription() {
        $option = $this->articleCard->get('description_option','default');
        if($option === 'default'){
            return $this->compressTrimText(strip_tags($this->article->misc),280);
        }
        $description = $this->compressTrimText($this->articleCard->get('description',false),280);
        if(!empty($description)){
            return $description;            
        }
        return $this->compressTrimText($this->app->getConfig()->get('MetaDesc',false),280);
    }
    protected function getTitle() {
        $option = $this->articleCard->get('title_option','default');
        if($option === 'default'){
            return $this->compressTrimText($this->article->name,280);
        }
        $title = $this->articleCard->get('title',false);
        if(!empty($title)){
            return $this->compressTrimText($title,280);            
        }
        return $this->compressTrimText($this->article->name,280);
    }
    protected function getImagePath() {
        $option = $this->articleCard->get('image_option','default');
        if($option === 'default'){
            $option = $this->defaultCard->get('image_option','any');
        }
         // map intro/full to any
        if(in_array($option, ['intro','full'], true)){
            $option = 'any';
        }
        switch($option){
            case 'custom':
                $image = $this->articleCard->get('image',false);
                if($image) {
                    $image = explode('#',$image)[0];
                    if($this->validImage($image)){
                        return $image;
                    }
                }
                break;
            case 'any':
                $image = $this->article->image;
                if($image) {
                    $image = explode('#',$image)[0];
                    if($this->validImage($image)){
                        return $image;
                    }
                }
                break;
        }
        $image = $this->defaultCard->get('fallback_image',false);
        $image = explode('#',$image)[0];
        return $image;
    }

    protected function getImage_alt() {
        $option = $this->articleCard->get('image_alt_option','default');
        if($option === 'default'){
            $option = $this->defaultCard->get('image_alt_option','title');
        }
        switch($option){
            case 'title':
                return $this->article->name;
            case 'custom':
                if($this->articleCard->get('image_alt',false)){
                    return $this->articleCard->get('image_alt',false);
                }
                break;
        }
        return false; // no alt text found
    }

}