<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  User.authlog
 *
 * @copyright   Copyright (C) 2005 - 2015 Michael Richey. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\User\AuthLog\Extension;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Date\Date;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class AuthLogHelper {

    static function display($user_id) {
        $plugin = PluginHelper::getPlugin('user', 'authlog');
        $params = new Registry($plugin->params);
        $admin = Factory::getApplication()->isClient('administrator');
        $values = self::_getRecords($user_id);
        if (count($values))
        {
            $rv = array('<table class="table table-bordered">');
            $rv[] = '<tr class="sticky-top">';
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_TS_HEADER') . '</th>';
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_IP_HEADER') . '</th>';
            if ($admin)
            {
                $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_ADMIN_HEADER') . '</th>';
            }
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_MOBILE_HEADER') . '</th>';
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_PLATFORM_HEADER') . '</th>';
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_BROWSER_HEADER') . '</th>';
            if ($admin)
            {
            $rv[] = '<th>' . Text::_('PLG_USER_AUTHLOG_URL_HEADER') . '</th>';
            }
            $rv[] = '</tr>';
            foreach ($values as $value)
            {
                $rv[] = self::_returnRow($value, $admin);
            }
            $rv[] = '</table>';
        }
        else
        {
            $rv = array(Text::_('PLG_USER_AUTHLOG_NOLOGS'));
        }
        return implode("\n", $rv);
    }

    private static function _getRecords($user_id) {
	    $db = Factory::getDbo();
        $query = $db->createQuery(true);
        $query->select('*')->from('#__plg_user_authlog');
        $query->where('user_id = ' . (int) $user_id);
        $query->order('ts DESC');
        $db->setQuery($query);
        return $db->loadObjectList();
    }

    private static function _returnRow($row, $admin) {
        if (!$admin && $row->admin)
        {
            return '';
        }
        $date = new Date($row->ts);
        $rv = array($date->format('r'));
        $rv[] = $row->ip;
        if ($admin)
        {
            $rv[] = $row->admin ? Text::_('PLG_USER_AUTHLOG_ADMIN') : Text::_('PLG_USER_AUTHLOG_SITE');
        }
        $rv[] = $row->mobile ? Text::_('PLG_USER_AUTHLOG_MOBILE') : '';
        $rv[] = self::_returnPlatform($row->platform);
        $rv[] = self::_returnBrowser($row->browser, $row->version);
        if ($admin)
        {
            $rv[] = '<a href="' . $row->entry_url . '" target="_blank">' . Text::_('PLG_USER_AUTHLOG_LINK') . '</a>';
        }
        switch($row->fail) {
            case 1:
            $class = ' class="table-danger"';
            break;
            case 2:
            $class = ' class="table-warning"';
            break;
            case 3:
            $class = ' class="table-info"';
            break;
            default:
            $class = ' class="table-success"';
            break;
        }
        return '<tr' . $class . '><td>' . implode('</td><td>', $rv) . '</td></tr>';
    }

    private static function _returnPlatform($platform) {
        return ucfirst($platform);
    }

    private static function _returnBrowser($browser, $version) {
        return ucfirst($browser) . ' ' . $version;
    }

}
