<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  User.staticemail
 *
 * @copyright   (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\User\StaticEmail\Extension;

use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * An example custom terms and conditions plugin.
 *
 * @since  3.9.0
 */
final class StaticEmail extends CMSPlugin
{

    public function onUserBeforeSave($user, $isnew, $new) {
        if (Factory::getApplication()->isClient('administrator') || $isnew) {
            return true;
        }
        $juser = Factory::getUser();
        $userGroups = $juser->groups;
        $restrictedGroups = $this->params->get('restrict', array());
        if(!empty(array_intersect($userGroups, $restrictedGroups))) {
            $new['email1']=$user->email;
            $new['email2']=$user->email;
            return true;
        }
        return true;
    }

    public function onContentPrepareForm(Form $form, $data): bool
    {
        if (!($form instanceof Form)) {
            $this->_subject->setError('JERROR_NOT_A_FORM');
            return false;
        }

        // Check we are manipulating a valid form.
        if (!in_array($form->getName(), array('com_users.user', 'com_users.profile'))) {
            return true;
        }
        if (Factory::getApplication()->isClient('administrator')) {
            return true;
        }
        $juser = Factory::getUser();
        $userGroups = $juser->groups;
        $restrictedGroups = $this->params->get('restrict', array());
        if(!empty(array_intersect($userGroups, $restrictedGroups))) {
            if($this->params->get('hide_email', 1)) {
                $form->setFieldAttribute('email1','type','hidden');
            } else {
                $form->setFieldAttribute('email1','readonly','true');
            }
            $form->setFieldAttribute('email2','type','hidden');
            return true;
        }
        return true;
    }
}