<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  User.staticemail
 *
 * @copyright   (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\User\StaticPassword\Extension;

use Joomla\CMS\Crypt\Crypt;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\ParameterType;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * An example custom terms and conditions plugin.
 *
 * @since  3.9.0
 */
final class StaticPassword extends CMSPlugin
{
    public function onUserBeforeSave($user, $isnew, $new) {
        if (!Factory::getApplication()->isClient('site') || $isnew) {
            error_log('exiting');
            return true;
        }
        $juser = Factory::getUser();
        $restrictedGroups = $this->params->get('restrict', array());
        $userGroups = $juser->groups;
        if(!empty(array_intersect($userGroups, $restrictedGroups))) {
            unset($new['password1']);
            unset($new['password2']);
            return true;
        }
        return true;
    }

    public function onContentPrepareForm(Form $form, $data): bool
    {
        if (!($form instanceof Form)) {
            $this->_subject->setError('JERROR_NOT_A_FORM');
            return false;
        }

        // Check we are manipulating a valid form.
        if (!in_array($form->getName(), array('com_users.user', 'com_users.profile'))) {
            return true;
        }
        if (!Factory::getApplication()->isClient('site')) {
            return true;
        }
        $juser = Factory::getUser();
        $restrictedGroups = $this->params->get('restrict', array());
        $userGroups = $juser->groups;
        if(!empty(array_intersect($userGroups, $restrictedGroups))) {
            $form->removeField('password1');
            $form->removeField('password2');
            return true;
        }
        return true;
    }
}